/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.resourcenames;

import com.google.api.resourcenames.UntypedResourceName;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UntypedResourceNameTest {
    private static final String NAME_STRING = "sunshine";
    private static final String EMPTY_STRING = "";

    UntypedResourceNameTest() {
    }

    @Test
    void testGetFieldValues() {
        Assertions.assertTrue((boolean)UntypedResourceName.isParsableFrom((String)NAME_STRING));
        UntypedResourceName fooName = UntypedResourceName.parse((String)NAME_STRING);
        Map fieldValuesMap = fooName.getFieldValuesMap();
        Assertions.assertTrue((boolean)fieldValuesMap.containsKey(EMPTY_STRING));
        Assertions.assertEquals((Object)NAME_STRING, fieldValuesMap.get(EMPTY_STRING));
        Assertions.assertEquals((int)1, (int)fieldValuesMap.size());
        Assertions.assertEquals(null, fieldValuesMap.get(NAME_STRING));
    }

    @Test
    void testInsertIntoFieldValuesMap() {
        UntypedResourceName fooName = UntypedResourceName.parse((String)NAME_STRING);
        Map fieldValuesMap = fooName.getFieldValuesMap();
        try {
            fieldValuesMap.put(EMPTY_STRING, "foo");
            TestCase.fail((String)"fieldValuesMap should prevent insertion into internal map. ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            fieldValuesMap.put(null, "foo");
            TestCase.fail((String)"fieldValuesMap should prevent insertion into internal map. ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            fieldValuesMap.put(NAME_STRING, NAME_STRING);
            TestCase.fail((String)"fieldValuesMap should prevent insertion into internal map. ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    void testNullName() {
        Assertions.assertFalse((boolean)UntypedResourceName.isParsableFrom(null));
        Assertions.assertThrows(NullPointerException.class, () -> UntypedResourceName.parse(null));
    }
}

