/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.authsub;

import com.google.api.client.googleapis.auth.authsub.AuthSub;
import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

final class AuthSubIntercepter
implements HttpExecuteIntercepter {
    private final String token;
    private final PrivateKey privateKey;

    AuthSubIntercepter(String token, PrivateKey privateKey) {
        this.token = token;
        this.privateKey = privateKey;
    }

    public void intercept(HttpRequest request) throws IOException {
        try {
            String token = this.token;
            PrivateKey privateKey = this.privateKey;
            String header = token == null ? null : (privateKey == null ? AuthSub.getAuthorizationHeaderValue(token) : AuthSub.getAuthorizationHeaderValue(token, privateKey, request.method, request.url.build()));
            request.headers.authorization = header;
        }
        catch (GeneralSecurityException e) {
            IOException wrap = new IOException();
            wrap.initCause(e);
            throw wrap;
        }
    }
}

