/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth;

import com.google.api.client.util.Base64;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;

public class RsaSha {
    private static final String BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String END = "-----END PRIVATE KEY-----";

    private RsaSha() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKeyFromKeystore(InputStream keyStream, String storePass, String alias, String keyPass) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            keyStore.load(keyStream, storePass.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyPass.toCharArray());
            return privateKey;
        }
        finally {
            keyStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKeyFromPk8(File file) throws IOException, GeneralSecurityException {
        byte[] privKeyBytes = new byte[(int)file.length()];
        DataInputStream inputStream = new DataInputStream(new FileInputStream(file));
        try {
            inputStream.readFully(privKeyBytes);
        }
        finally {
            inputStream.close();
        }
        String str = new String(privKeyBytes);
        if (str.startsWith(BEGIN) && str.endsWith(END)) {
            str = str.substring(BEGIN.length(), str.lastIndexOf(END));
        }
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.decode(str.getBytes("UTF-8")));
        return fac.generatePrivate(privKeySpec);
    }

    public static String sign(PrivateKey privateKey, String data) throws GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(privateKey);
        try {
            signature.update(data.getBytes("UTF-8"));
            return new String(Base64.encode(signature.sign()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

