/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.authsub;

import com.google.api.client.googleapis.auth.AuthKeyValueParser;
import com.google.api.client.googleapis.auth.authsub.AuthSubIntercepter;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.security.PrivateKey;

public final class AuthSubHelper {
    private PrivateKey privateKey;
    private HttpTransport transport;
    private final HttpTransport authSubTransport = new HttpTransport();
    private String token;

    public AuthSubHelper() {
        this.authSubTransport.addParser(AuthKeyValueParser.INSTANCE);
    }

    public void setPrivateKey(PrivateKey privateKey) {
        if (privateKey != this.privateKey) {
            this.privateKey = privateKey;
            this.updateAuthorizationHeaders();
        }
    }

    public void setTransport(HttpTransport transport) {
        if (transport != this.transport) {
            this.transport = transport;
            this.updateAuthorizationHeaders();
        }
    }

    public void setToken(String token) {
        if (token != this.token) {
            this.token = token;
            this.updateAuthorizationHeaders();
        }
    }

    public String exchangeForSessionToken() throws IOException {
        HttpTransport authSubTransport = this.authSubTransport;
        HttpRequest request = authSubTransport.buildGetRequest();
        request.setUrl("https://www.google.com/accounts/AuthSubSessionToken");
        SessionTokenResponse sessionTokenResponse = request.execute().parseAs(SessionTokenResponse.class);
        String sessionToken = sessionTokenResponse.sessionToken;
        this.setToken(sessionToken);
        return sessionToken;
    }

    public void revokeSessionToken() throws IOException {
        HttpTransport authSubTransport = this.authSubTransport;
        HttpRequest request = authSubTransport.buildGetRequest();
        request.setUrl("https://www.google.com/accounts/AuthSubRevokeToken");
        request.execute().ignore();
        this.setToken(null);
    }

    public TokenInfoResponse requestTokenInfo() throws IOException {
        HttpTransport authSubTransport = this.authSubTransport;
        HttpRequest request = authSubTransport.buildGetRequest();
        request.setUrl("https://www.google.com/accounts/AuthSubTokenInfo");
        HttpResponse response = request.execute();
        if (response.getParser() == null) {
            throw new IllegalStateException(response.parseAsString());
        }
        return response.parseAs(TokenInfoResponse.class);
    }

    private void updateAuthorizationHeaders() {
        HttpTransport authSubTransport;
        HttpTransport transport = this.transport;
        if (transport != null) {
            this.setAuthorizationHeaderOf(transport);
        }
        if ((authSubTransport = this.authSubTransport) != null) {
            this.setAuthorizationHeaderOf(authSubTransport);
        }
    }

    private void setAuthorizationHeaderOf(HttpTransport transoprt) {
        this.transport.intercepters.add(new AuthSubIntercepter(this.token, this.privateKey));
    }

    public static final class TokenInfoResponse {
        @Key(value="Secure")
        public boolean secure;
        @Key(value="Target")
        public String target;
        @Key(value="Scope")
        public String scope;
    }

    public static final class SessionTokenResponse {
        @Key(value="Token")
        public String sessionToken;
    }
}

