/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.escape.CharEscapers;
import com.google.api.client.googleapis.GoogleTransport;
import com.google.api.client.googleapis.json.JsonCParser;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.Json;
import com.google.api.client.util.DataUtil;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonParser;

public final class DiscoveryDocument {
    public final ServiceDefinition serviceDefinition;
    public HttpTransport transport;

    DiscoveryDocument(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    @Deprecated
    public static DiscoveryDocument execute(String api) throws IOException {
        return DiscoveryDocument.load(api);
    }

    public static DiscoveryDocument load(String apiName) throws IOException {
        GenericUrl discoveryUrl = new GenericUrl("http://www.googleapis.com/discovery/0.1/describe");
        discoveryUrl.put("api", (Object)apiName);
        HttpTransport transport = GoogleTransport.create();
        HttpRequest request = transport.buildGetRequest();
        request.url = discoveryUrl;
        JsonParser parser = JsonCParser.parserForResponse(request.execute());
        Json.skipToKey(parser, apiName);
        Json.skipToKey(parser, "1.0");
        ServiceDefinition serviceDefinition = new ServiceDefinition();
        Json.parseAndClose(parser, serviceDefinition, null);
        return new DiscoveryDocument(serviceDefinition);
    }

    public HttpRequest buildRequest(String fullyQualifiedMethodName, Object parameters) throws IOException {
        HttpTransport transport = this.transport;
        if (transport == null) {
            throw new IllegalArgumentException("missing transport");
        }
        ServiceDefinition serviceDefinition = this.serviceDefinition;
        ServiceMethod method = serviceDefinition.getResourceMethod(fullyQualifiedMethodName);
        if (method == null) {
            throw new IllegalArgumentException("unrecognized method: " + fullyQualifiedMethodName);
        }
        HttpRequest request = transport.buildRequest();
        request.method = method.httpMethod;
        HashMap<String, String> requestMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : DataUtil.mapOf(parameters).entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            requestMap.put(entry.getKey(), value.toString());
        }
        GenericUrl url = new GenericUrl(serviceDefinition.baseUrl);
        String pathUrl = method.pathUrl;
        StringBuilder pathBuf = new StringBuilder();
        int cur = 0;
        int length = pathUrl.length();
        while (cur < length) {
            int next = pathUrl.indexOf(123, cur);
            if (next == -1) {
                pathBuf.append(pathUrl.substring(cur));
                break;
            }
            pathBuf.append(pathUrl.substring(cur, next));
            int close = pathUrl.indexOf(125, next + 2);
            String varName = pathUrl.substring(next + 1, close);
            cur = close + 1;
            String value = (String)requestMap.remove(varName);
            if (value == null) {
                throw new IllegalArgumentException("missing required path parameter: " + varName);
            }
            pathBuf.append(CharEscapers.escapeUriPath(value));
        }
        url.appendRawPath(pathBuf.toString());
        url.putAll((Map<? extends String, ?>)requestMap);
        request.url = url;
        return request;
    }

    public static final class ServiceParameter {
        @Key
        public boolean required;
    }

    public static final class ServiceMethod {
        @Key
        String pathUrl;
        @Key
        public String httpMethod;
        @Key
        public Map<String, ServiceParameter> parameters;
        @Key
        final String methodType = "rest";
    }

    public static final class ServiceResource {
        @Key
        public Map<String, ServiceMethod> methods;
    }

    public static final class ServiceDefinition {
        @Key
        String baseUrl;
        @Key
        public Map<String, ServiceResource> resources;

        public ServiceMethod getResourceMethod(String methodIdentifier) {
            int dot = methodIdentifier.indexOf(46);
            String resourceName = methodIdentifier.substring(0, dot);
            String methodName = methodIdentifier.substring(dot + 1);
            ServiceResource resource = this.resources.get(resourceName);
            return resource == null ? null : resource.methods.get(methodName);
        }

        String getResourceUrl(String methodIdentifier) {
            return this.baseUrl + this.getResourceMethod((String)methodIdentifier).pathUrl;
        }
    }
}

