/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.googleapis.GoogleHeaders;
import com.google.api.client.googleapis.MethodOverrideIntercepter;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;

public class GoogleTransport
extends HttpTransport {
    @Deprecated
    public static boolean ENABLE_METHOD_OVERRIDE = false;
    @Deprecated
    public String applicationName;

    public static HttpTransport create() {
        HttpTransport transport = new HttpTransport();
        MethodOverrideIntercepter.setAsFirstFor(transport);
        transport.defaultHeaders = new GoogleHeaders();
        return transport;
    }

    @Deprecated
    public GoogleTransport() {
    }

    @Deprecated
    public void setVersionHeader(String version) {
        this.defaultHeaders.set("GData-Version", version);
    }

    @Deprecated
    public void setClientLoginToken(String authToken) {
        this.defaultHeaders.authorization = GoogleTransport.getClientLoginHeaderValue(authToken);
    }

    @Deprecated
    public static String getClientLoginHeaderValue(String authToken) {
        return "GoogleLogin auth=" + authToken;
    }

    public HttpRequest buildDeleteRequest() {
        if (!ENABLE_METHOD_OVERRIDE) {
            return super.buildDeleteRequest();
        }
        return this.buildMethodOverride("DELETE");
    }

    public HttpRequest buildPatchRequest() {
        if (!ENABLE_METHOD_OVERRIDE && GoogleTransport.useLowLevelHttpTransport().supportsPatch()) {
            return super.buildPatchRequest();
        }
        return this.buildMethodOverride("PATCH");
    }

    public HttpRequest buildPutRequest() {
        if (!ENABLE_METHOD_OVERRIDE) {
            return super.buildPutRequest();
        }
        return this.buildMethodOverride("PUT");
    }

    private HttpRequest buildMethodOverride(String method) {
        HttpRequest request = this.buildPostRequest();
        request.headers.set("X-HTTP-Method-Override", method);
        return request;
    }
}

