/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.escape.PercentEscaper;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.Key;

public class GoogleHeaders
extends HttpHeaders {
    public static final PercentEscaper SLUG_ESCAPER = new PercentEscaper(" !\"#$&'()*+,-./:;<=>?@[\\]^_`{|}~", false);
    @Key(value="GData-Version")
    public String gdataVersion;
    @Key(value="Slug")
    public String slug;
    @Key(value="X-GData-Client")
    public String gdataClient;
    @Key(value="X-GData-Key")
    public String gdataKey;
    @Key(value="x-goog-acl")
    public String googAcl;
    @Key(value="x-goog-copy-source")
    public String googCopySource;
    @Key(value="x-goog-copy-source-if-match")
    public String googCopySourceIfMatch;
    @Key(value="x-goog-copy-source-if-none-match")
    public String googCopySourceIfNoneMatch;
    @Key(value="x-goog-copy-source-if-modified-since")
    public String googCopySourceIfModifiedSince;
    @Key(value="x-goog-copy-source-if-unmodified-since")
    public String googCopySourceIfUnmodifiedSince;
    @Key(value="x-goog-date")
    public String googDate;
    @Key(value="x-goog-metadata-directive")
    public String googMetadataDirective;
    @Key(value="X-HTTP-Method-Override")
    public String methodOverride;

    @Deprecated
    public static void setSlug(HttpHeaders headers, String fileName) {
        headers.set("Slug", SLUG_ESCAPER.escape(fileName));
    }

    public void setSlugFromFileName(String fileName) {
        this.slug = SLUG_ESCAPER.escape(fileName);
    }

    public void setApplicationName(String applicationName) {
        this.userAgent = applicationName;
    }

    public void setDeveloperId(String developerId) {
        this.gdataKey = "key=" + developerId;
    }

    public void setGoogleLogin(String authToken) {
        this.authorization = GoogleHeaders.getGoogleLoginValue(authToken);
    }

    public static String getGoogleLoginValue(String authToken) {
        return "GoogleLogin auth=" + authToken;
    }
}

