/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.escape.CharEscapers;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlEncodedParser
implements HttpParser {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    public boolean disableContentLogging;
    public String contentType = "application/x-www-form-urlencoded";

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        if (this.disableContentLogging) {
            response.disableContentLogging = true;
        }
        T newInstance = ClassInfo.newInstance(dataClass);
        UrlEncodedParser.parse(response.parseAsString(), newInstance);
        return newInstance;
    }

    public static void parse(String content, Object data) {
        Class<?> clazz = data.getClass();
        ClassInfo classInfo = ClassInfo.of(clazz);
        GenericData genericData = GenericData.class.isAssignableFrom(clazz) ? (GenericData)data : null;
        Map map = Map.class.isAssignableFrom(clazz) ? (Map)data : null;
        int cur = 0;
        int length = content.length();
        int nextEquals = content.indexOf(61);
        while (cur < length) {
            String stringValue;
            String name;
            int amp = content.indexOf(38, cur);
            if (amp == -1) {
                amp = length;
            }
            if (nextEquals != -1 && nextEquals < amp) {
                name = content.substring(cur, nextEquals);
                stringValue = CharEscapers.decodeUri(content.substring(nextEquals + 1, amp));
                nextEquals = content.indexOf(61, amp + 1);
            } else {
                name = content.substring(cur, amp);
                stringValue = "";
            }
            name = CharEscapers.decodeUri(name);
            FieldInfo fieldInfo = classInfo.getFieldInfo(name);
            if (fieldInfo != null) {
                Class<?> type = fieldInfo.type;
                if (Collection.class.isAssignableFrom(type)) {
                    Collection<Object> collection = (Collection<Object>)fieldInfo.getValue(data);
                    if (collection == null) {
                        collection = ClassInfo.newCollectionInstance(type);
                        fieldInfo.setValue(data, collection);
                    }
                    Class<?> subFieldClass = ClassInfo.getCollectionParameter(fieldInfo.field);
                    collection.add(FieldInfo.parsePrimitiveValue(subFieldClass, stringValue));
                } else {
                    fieldInfo.setValue(data, FieldInfo.parsePrimitiveValue(type, stringValue));
                }
            } else {
                ArrayList<String> listValue = (ArrayList<String>)map.get(name);
                if (listValue == null) {
                    listValue = new ArrayList<String>();
                    if (genericData != null) {
                        genericData.set(name, listValue);
                    } else {
                        map.put(name, listValue);
                    }
                }
                listValue.add(stringValue);
            }
            cur = amp + 1;
        }
    }
}

