/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth;

import com.google.api.client.auth.oauth.OAuthAuthorizationHeaderIntercepter;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.escape.PercentEscaper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpTransport;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthParameters {
    private static final SecureRandom RANDOM = new SecureRandom();
    public OAuthSigner signer;
    public String callback;
    public String consumerKey;
    public String nonce;
    public String realm;
    public String signature;
    public String signatureMethod;
    public String timestamp;
    public String token;
    public String verifier;
    public String version;
    private static final PercentEscaper ESCAPER = new PercentEscaper("-_.~", false);

    public void computeNonce() {
        this.nonce = Long.toHexString(Math.abs(RANDOM.nextLong()));
    }

    public void computeTimestamp() {
        this.timestamp = Long.toString(System.currentTimeMillis() / 1000L);
    }

    public void computeSignature(String requestMethod, GenericUrl requestUrl) throws GeneralSecurityException {
        OAuthSigner signer = this.signer;
        String signatureMethod = this.signatureMethod = signer.getSignatureMethod();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        this.putParameterIfValueNotNull(parameters, "oauth_callback", this.callback);
        this.putParameterIfValueNotNull(parameters, "oauth_consumer_key", this.consumerKey);
        this.putParameterIfValueNotNull(parameters, "oauth_nonce", this.nonce);
        this.putParameterIfValueNotNull(parameters, "oauth_signature_method", signatureMethod);
        this.putParameterIfValueNotNull(parameters, "oauth_timestamp", this.timestamp);
        this.putParameterIfValueNotNull(parameters, "oauth_token", this.token);
        this.putParameterIfValueNotNull(parameters, "oauth_verifier", this.verifier);
        this.putParameterIfValueNotNull(parameters, "oauth_version", this.version);
        for (Map.Entry<String, Object> fieldEntry : requestUrl.entrySet()) {
            Object value = fieldEntry.getValue();
            if (value == null) continue;
            String name = fieldEntry.getKey();
            if (value instanceof Collection) {
                for (Object repeatedValue : (Collection)value) {
                    this.putParameter(parameters, name, repeatedValue);
                }
                continue;
            }
            this.putParameter(parameters, name, value);
        }
        StringBuilder parametersBuf = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                parametersBuf.append('&');
            }
            parametersBuf.append(entry.getKey());
            String value = entry.getValue();
            if (value == null) continue;
            parametersBuf.append('=').append(value);
        }
        String normalizedParameters = parametersBuf.toString();
        GenericUrl normalized = new GenericUrl();
        String scheme = normalized.scheme = requestUrl.scheme;
        normalized.host = requestUrl.host;
        normalized.pathParts = requestUrl.pathParts;
        int port = requestUrl.port;
        if ("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            port = -1;
        }
        normalized.port = port;
        String normalizedPath = normalized.build();
        StringBuilder buf = new StringBuilder();
        buf.append(OAuthParameters.escape(requestMethod)).append('&');
        buf.append(OAuthParameters.escape(normalizedPath)).append('&');
        buf.append(OAuthParameters.escape(normalizedParameters));
        String signatureBaseString = buf.toString();
        this.signature = signer.computeSignature(signatureBaseString);
    }

    public String getAuthorizationHeader() {
        StringBuilder buf = new StringBuilder("OAuth");
        this.appendParameter(buf, "realm", this.realm);
        this.appendParameter(buf, "oauth_callback", this.callback);
        this.appendParameter(buf, "oauth_consumer_key", this.consumerKey);
        this.appendParameter(buf, "oauth_nonce", this.nonce);
        this.appendParameter(buf, "oauth_signature", this.signature);
        this.appendParameter(buf, "oauth_signature_method", this.signatureMethod);
        this.appendParameter(buf, "oauth_timestamp", this.timestamp);
        this.appendParameter(buf, "oauth_token", this.token);
        this.appendParameter(buf, "oauth_verifier", this.verifier);
        this.appendParameter(buf, "oauth_version", this.version);
        return buf.substring(0, buf.length() - 1);
    }

    private void appendParameter(StringBuilder buf, String name, String value) {
        if (value != null) {
            buf.append(' ').append(OAuthParameters.escape(name)).append("=\"").append(OAuthParameters.escape(value)).append("\",");
        }
    }

    private void putParameterIfValueNotNull(TreeMap<String, String> parameters, String key, String value) {
        if (value != null) {
            this.putParameter(parameters, key, value);
        }
    }

    private void putParameter(TreeMap<String, String> parameters, String key, Object value) {
        parameters.put(OAuthParameters.escape(key), value == null ? null : OAuthParameters.escape(value.toString()));
    }

    public static String escape(String value) {
        return ESCAPER.escape(value);
    }

    public void signRequestsUsingAuthorizationHeader(HttpTransport transport) {
        for (HttpExecuteIntercepter intercepter : transport.intercepters) {
            if (intercepter.getClass() != OAuthAuthorizationHeaderIntercepter.class) continue;
            ((OAuthAuthorizationHeaderIntercepter)intercepter).oauthParameters = this;
            return;
        }
        OAuthAuthorizationHeaderIntercepter newIntercepter = new OAuthAuthorizationHeaderIntercepter();
        newIntercepter.oauthParameters = this;
        transport.intercepters.add(newIntercepter);
    }
}

