/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.GenericData;
import java.util.Arrays;
import java.util.List;

public final class AccessProtectedResource {
    public static void usingAuthorizationHeader(HttpTransport transport, String accessToken) {
        new UsingAuthorizationHeader().authorize(transport, accessToken);
    }

    public static void usingQueryParameter(HttpTransport transport, String accessToken) {
        new UsingQueryParameter().authorize(transport, accessToken);
    }

    public static void usingFormEncodedBody(HttpTransport transport, String accessToken) {
        new UsingFormEncodedBody().authorize(transport, accessToken);
    }

    private AccessProtectedResource() {
    }

    static final class UsingFormEncodedBody
    extends AccessTokenIntercepter {
        private static final List<String> ALLOWED_METHODS = Arrays.asList("POST", "PUT", "DELETE");

        UsingFormEncodedBody() {
        }

        public void intercept(HttpRequest request) {
            GenericData data;
            if (!ALLOWED_METHODS.contains(request.method)) {
                throw new IllegalArgumentException("expected one of these HTTP methods: " + ALLOWED_METHODS);
            }
            UrlEncodedContent content = (UrlEncodedContent)request.content;
            if (content == null) {
                content = new UrlEncodedContent();
                request.content = content;
            }
            if ((data = (GenericData)content.data) == null) {
                data = new GenericData();
                content.data = data;
            }
            data.put("oauth_token", (Object)this.accessToken);
        }
    }

    static final class UsingQueryParameter
    extends AccessTokenIntercepter {
        UsingQueryParameter() {
        }

        public void intercept(HttpRequest request) {
            request.url.set("oauth_token", this.accessToken);
        }
    }

    static final class UsingAuthorizationHeader
    extends AccessTokenIntercepter {
        UsingAuthorizationHeader() {
        }

        public void intercept(HttpRequest request) {
            request.headers.authorization = "Token token=\"" + this.accessToken + "\"";
        }
    }

    static abstract class AccessTokenIntercepter
    implements HttpExecuteIntercepter {
        String accessToken;

        AccessTokenIntercepter() {
        }

        void authorize(HttpTransport transport, String accessToken) {
            this.accessToken = accessToken;
            transport.removeIntercepters(AccessTokenIntercepter.class);
            transport.intercepters.add(this);
        }
    }
}

