/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.clientlogin;

import com.google.api.client.googleapis.GoogleHeaders;
import com.google.api.client.googleapis.auth.AuthKeyValueParser;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Key;
import java.io.IOException;

public final class ClientLogin {
    @Key(value="source")
    public String applicationName;
    @Key(value="service")
    public String authTokenType;
    @Key(value="Email")
    public String username;
    @Key(value="Passwd")
    public String password;
    @Key
    public String accountType;
    @Key(value="logintoken")
    public String captchaToken;
    @Key(value="logincaptcha")
    public String captchaAnswer;

    public Response authenticate() throws HttpResponseException, IOException {
        HttpTransport transport = new HttpTransport();
        transport.addParser(AuthKeyValueParser.INSTANCE);
        HttpRequest request = transport.buildPostRequest();
        request.setUrl("https://www.google.com/accounts/ClientLogin");
        UrlEncodedContent content = new UrlEncodedContent();
        content.data = this;
        request.disableContentLogging = true;
        request.content = content;
        return request.execute().parseAs(Response.class);
    }

    public static final class ErrorInfo {
        @Key(value="Error")
        public String error;
        @Key(value="Url")
        public String url;
        @Key(value="CaptchaToken")
        public String captchaToken;
        @Key(value="CaptchaUrl")
        public String captchaUrl;
    }

    public static final class Response {
        @Key(value="Auth")
        public String auth;

        public String getAuthorizationHeaderValue() {
            return GoogleHeaders.getGoogleLoginValue(this.auth);
        }

        public void setAuthorizationHeader(HttpTransport googleTransport) {
            googleTransport.defaultHeaders.authorization = GoogleHeaders.getGoogleLoginValue(this.auth);
        }
    }
}

