/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.escape.CharEscapers;
import com.google.api.client.googleapis.GoogleTransport;
import com.google.api.client.googleapis.json.DiscoveryDocument;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.client.util.DataUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class GoogleApi {
    public String name;
    public String version;
    public HttpTransport transport = GoogleTransport.create();
    public DiscoveryDocument.ServiceDefinition serviceDefinition;

    public void load() throws IOException {
        DiscoveryDocument doc = DiscoveryDocument.load(this.name);
        this.serviceDefinition = (DiscoveryDocument.ServiceDefinition)doc.apiDefinition.get(this.version);
        Preconditions.checkNotNull(this.serviceDefinition, "version not found: %s", this.version);
    }

    public HttpRequest buildRequest(String fullyQualifiedMethodName, Object parameters) throws IOException {
        String name = this.name;
        String version = this.version;
        HttpTransport transport = this.transport;
        DiscoveryDocument.ServiceDefinition serviceDefinition = this.serviceDefinition;
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(version);
        Preconditions.checkNotNull(transport);
        Preconditions.checkNotNull(fullyQualifiedMethodName);
        if (serviceDefinition == null) {
            this.load();
        }
        DiscoveryDocument.ServiceMethod method = serviceDefinition.getResourceMethod(fullyQualifiedMethodName);
        Preconditions.checkNotNull(method, "method not found: %s", fullyQualifiedMethodName);
        HttpRequest request = transport.buildRequest();
        request.method = method.httpMethod;
        HashMap<String, String> requestMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : DataUtil.mapOf(parameters).entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            requestMap.put(entry.getKey(), value.toString());
        }
        GenericUrl url = new GenericUrl(serviceDefinition.baseUrl);
        String pathUrl = method.pathUrl;
        StringBuilder pathBuf = new StringBuilder();
        int cur = 0;
        int length = pathUrl.length();
        while (cur < length) {
            int next = pathUrl.indexOf(123, cur);
            if (next == -1) {
                pathBuf.append(pathUrl.substring(cur));
                break;
            }
            pathBuf.append(pathUrl.substring(cur, next));
            int close = pathUrl.indexOf(125, next + 2);
            String varName = pathUrl.substring(next + 1, close);
            cur = close + 1;
            String value = (String)requestMap.remove(varName);
            if (value == null) {
                throw new IllegalArgumentException("missing required path parameter: " + varName);
            }
            pathBuf.append(CharEscapers.escapeUriPath(value));
        }
        url.appendRawPath(pathBuf.toString());
        url.putAll((Map<? extends String, ?>)requestMap);
        request.url = url;
        return request;
    }
}

