/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.json.AbstractJsonFeedParser;
import com.google.api.client.googleapis.json.JsonCParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.Json;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonMultiKindFeedParser<T>
extends AbstractJsonFeedParser<T> {
    private final HashMap<String, Class<?>> kindToItemClassMap = new HashMap();

    public JsonMultiKindFeedParser(JsonParser parser, Class<T> feedClass, Class<?> ... itemClasses) {
        super(parser, feedClass);
        int numItems = itemClasses.length;
        HashMap<String, Class<?>> kindToItemClassMap = this.kindToItemClassMap;
        for (int i = 0; i < numItems; ++i) {
            Class<?> itemClass = itemClasses[i];
            ClassInfo classInfo = ClassInfo.of(itemClass);
            Field field = classInfo.getField("kind");
            if (field == null) {
                throw new IllegalArgumentException("missing kind field for " + itemClass.getName());
            }
            Object item = ClassInfo.newInstance(itemClass);
            String kind = (String)FieldInfo.getFieldValue(field, item);
            if (kind == null) {
                throw new IllegalArgumentException("missing value for kind field in " + itemClass.getName());
            }
            kindToItemClassMap.put(kind, itemClass);
        }
    }

    @Override
    Object parseItemInternal() throws IOException {
        this.parser.nextToken();
        String key = this.parser.getCurrentName();
        if (key != "kind") {
            throw new IllegalArgumentException("expected kind field: " + key);
        }
        this.parser.nextToken();
        String kind = this.parser.getText();
        Class<?> itemClass = this.kindToItemClassMap.get(kind);
        if (itemClass == null) {
            throw new IllegalArgumentException("unrecognized kind: " + kind);
        }
        return Json.parse(this.parser, itemClass, null);
    }

    public static <T, I> JsonMultiKindFeedParser<T> use(HttpResponse response, Class<T> feedClass, Class<?> ... itemClasses) throws IOException {
        return new JsonMultiKindFeedParser<T>(JsonCParser.parserForResponse(response), feedClass, itemClasses);
    }
}

