/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.xml.atom;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.DataUtil;
import com.google.api.client.util.FieldInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GData {
    public static String getFieldsFor(Class<?> dataClass) {
        StringBuilder fieldsBuf = new StringBuilder();
        GData.appendFieldsFor(fieldsBuf, dataClass, new int[1]);
        return fieldsBuf.toString();
    }

    public static String getFeedFields(Class<?> feedClass, Class<?> entryClass) {
        StringBuilder fieldsBuf = new StringBuilder();
        GData.appendFeedFields(fieldsBuf, feedClass, entryClass);
        return fieldsBuf.toString();
    }

    private static void appendFieldsFor(StringBuilder fieldsBuf, Class<?> dataClass, int[] numFields) {
        if (Map.class.isAssignableFrom(dataClass) || Collection.class.isAssignableFrom(dataClass)) {
            throw new IllegalArgumentException("cannot specify field mask for a Map or Collection class: " + dataClass);
        }
        ClassInfo classInfo = ClassInfo.of(dataClass);
        for (String name : new TreeSet<String>(classInfo.getKeyNames())) {
            FieldInfo fieldInfo = classInfo.getFieldInfo(name);
            if (fieldInfo.isFinal) continue;
            numFields[0] = numFields[0] + 1;
            if (numFields[0] != 1) {
                fieldsBuf.append(',');
            }
            fieldsBuf.append(name);
            Class<?> fieldClass = fieldInfo.type;
            if (Collection.class.isAssignableFrom(fieldClass)) {
                fieldClass = ClassInfo.getCollectionParameter(fieldInfo.field);
            }
            if (fieldClass == null) continue;
            if (fieldInfo.isPrimitive) {
                if (name.charAt(0) == '@' || name.equals("text()")) continue;
                continue;
            }
            if (Collection.class.isAssignableFrom(fieldClass) || Map.class.isAssignableFrom(fieldClass)) continue;
            int[] subNumFields = new int[1];
            int openParenIndex = fieldsBuf.length();
            fieldsBuf.append('(');
            GData.appendFieldsFor(fieldsBuf, fieldClass, subNumFields);
            GData.updateFieldsBasedOnNumFields(fieldsBuf, openParenIndex, subNumFields[0]);
        }
    }

    private static void appendFeedFields(StringBuilder fieldsBuf, Class<?> feedClass, Class<?> entryClass) {
        int[] numFields = new int[1];
        GData.appendFieldsFor(fieldsBuf, feedClass, numFields);
        if (numFields[0] != 0) {
            fieldsBuf.append(",");
        }
        fieldsBuf.append("entry(");
        int openParenIndex = fieldsBuf.length() - 1;
        numFields[0] = 0;
        GData.appendFieldsFor(fieldsBuf, entryClass, numFields);
        GData.updateFieldsBasedOnNumFields(fieldsBuf, openParenIndex, numFields[0]);
    }

    private static void updateFieldsBasedOnNumFields(StringBuilder fieldsBuf, int openParenIndex, int numFields) {
        switch (numFields) {
            case 0: {
                fieldsBuf.deleteCharAt(openParenIndex);
                break;
            }
            case 1: {
                fieldsBuf.setCharAt(openParenIndex, '/');
                break;
            }
            default: {
                fieldsBuf.append(')');
            }
        }
    }

    public static ArrayMap<String, Object> computePatch(Object patched, Object original) {
        FieldsMask fieldsMask = new FieldsMask();
        ArrayMap<String, Object> result = GData.computePatchInternal(fieldsMask, patched, original);
        if (fieldsMask.numDifferences != 0) {
            result.put("@gd:fields", fieldsMask.buf.toString());
        }
        return result;
    }

    public static ArrayMap<String, Object> computePatchInternal(FieldsMask fieldsMask, Object patchedObject, Object originalObject) {
        ArrayMap<String, Object> result = ArrayMap.create();
        Map<String, Object> patchedMap = DataUtil.mapOf(patchedObject);
        Map<String, Object> originalMap = DataUtil.mapOf(originalObject);
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.addAll(patchedMap.keySet());
        fieldNames.addAll(originalMap.keySet());
        for (String name : fieldNames) {
            Class<?> type;
            Object patchedValue;
            Object originalValue = originalMap.get(name);
            if (originalValue == (patchedValue = patchedMap.get(name))) continue;
            Class<?> clazz = type = originalValue == null ? patchedValue.getClass() : originalValue.getClass();
            if (FieldInfo.isPrimitive(type)) {
                if (originalValue != null && originalValue.equals(patchedValue)) continue;
                fieldsMask.append(name);
                if (patchedValue == null) continue;
                result.add(name, patchedValue);
                continue;
            }
            if (Collection.class.isAssignableFrom(type)) {
                if (originalValue != null && patchedValue != null) {
                    Collection originalCollection = (Collection)originalValue;
                    Collection patchedCollection = (Collection)patchedValue;
                    int size = originalCollection.size();
                    if (size == patchedCollection.size()) {
                        int i;
                        for (i = 0; i < size; ++i) {
                            FieldsMask subFieldsMask = new FieldsMask();
                            GData.computePatchInternal(subFieldsMask, patchedValue, originalValue);
                            if (subFieldsMask.numDifferences != 0) break;
                        }
                        if (i == size) continue;
                    }
                }
                throw new UnsupportedOperationException("not yet implemented: support for patching collections");
            }
            if (originalValue == null) {
                fieldsMask.append(name);
                result.add(name, DataUtil.mapOf(patchedValue));
                continue;
            }
            if (patchedValue == null) {
                fieldsMask.append(name);
                continue;
            }
            FieldsMask subFieldsMask = new FieldsMask();
            ArrayMap<String, Object> patch = GData.computePatchInternal(subFieldsMask, patchedValue, originalValue);
            int numDifferences = subFieldsMask.numDifferences;
            if (numDifferences == 0) continue;
            fieldsMask.append(name, subFieldsMask);
            result.add(name, patch);
        }
        return result;
    }

    private GData() {
    }

    static class FieldsMask {
        int numDifferences;
        StringBuilder buf = new StringBuilder();

        FieldsMask() {
        }

        void append(String name) {
            StringBuilder buf = this.buf;
            if (++this.numDifferences != 1) {
                buf.append(',');
            }
            buf.append(name);
        }

        void append(String name, FieldsMask subFields) {
            boolean isSingle;
            this.append(name);
            StringBuilder buf = this.buf;
            boolean bl = isSingle = subFields.numDifferences == 1;
            if (isSingle) {
                buf.append('/');
            } else {
                buf.append('(');
            }
            buf.append((CharSequence)subFields.buf);
            if (!isSingle) {
                buf.append(')');
            }
        }
    }
}

