/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpContent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class InputStreamContent
implements HttpContent {
    private static final int BUFFER_SIZE = 2048;
    public String type;
    public long length = -1L;
    public InputStream inputStream;
    public String encoding;

    public void setFileInput(File file) throws FileNotFoundException {
        this.inputStream = new FileInputStream(file);
        this.length = file.length();
    }

    public void setByteArrayInput(byte[] content) {
        this.inputStream = new ByteArrayInputStream(content);
        this.length = content.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        InputStream inputStream = this.inputStream;
        long contentLength = this.length;
        if (contentLength < 0L) {
            InputStreamContent.copy(inputStream, out);
        } else {
            byte[] buffer = new byte[2048];
            try {
                int read;
                for (long remaining = contentLength; remaining > 0L; remaining -= (long)read) {
                    read = inputStream.read(buffer, 0, (int)Math.min(2048L, remaining));
                    if (read == -1) {
                        break;
                    }
                    out.write(buffer, 0, read);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getLength() {
        return this.length;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int bytesRead;
            byte[] tmp = new byte[2048];
            while ((bytesRead = inputStream.read(tmp)) != -1) {
                outputStream.write(tmp, 0, bytesRead);
            }
        }
        finally {
            inputStream.close();
        }
    }
}

