/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.javanet;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.javanet.NetHttpResponse;
import com.google.api.client.javanet.NetHttpTransport;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private HttpContent content;
    private final NetHttpTransport transport;

    NetHttpRequest(NetHttpTransport transport, String requestMethod, String url) throws IOException {
        this.transport = transport;
        HttpURLConnection connection = this.connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(requestMethod);
        connection.setUseCaches(false);
    }

    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    public LowLevelHttpResponse execute() throws IOException {
        int connectTimeout;
        HttpURLConnection connection = this.connection;
        HttpContent content = this.content;
        if (content != null) {
            long contentLength;
            connection.setDoOutput(true);
            this.addHeader("Content-Type", content.getType());
            String contentEncoding = content.getEncoding();
            if (contentEncoding != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = content.getLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(contentLength));
            }
            content.writeTo(connection.getOutputStream());
        }
        NetHttpTransport transport = this.transport;
        int readTimeout = transport.readTimeout;
        if (readTimeout >= 0) {
            connection.setReadTimeout(readTimeout);
        }
        if ((connectTimeout = transport.connectTimeout) >= 0) {
            connection.setReadTimeout(connectTimeout);
        }
        connection.connect();
        return new NetHttpResponse(connection);
    }

    public void setContent(HttpContent content) {
        this.content = content;
    }
}

