/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.apache;

import com.google.api.client.apache.ApacheHttpRequest;
import com.google.api.client.apache.HttpPatch;
import com.google.api.client.http.LowLevelHttpTransport;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class ApacheHttpTransport
extends LowLevelHttpTransport {
    public final HttpClient httpClient;
    public static final ApacheHttpTransport INSTANCE = new ApacheHttpTransport();

    ApacheHttpTransport() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        params.setBooleanParameter("http.protocol.handle-redirects", false);
        this.httpClient = new DefaultHttpClient((HttpParams)params);
    }

    public boolean supportsHead() {
        return true;
    }

    public boolean supportsPatch() {
        return true;
    }

    public ApacheHttpRequest buildDeleteRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpDelete(url));
    }

    public ApacheHttpRequest buildGetRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpGet(url));
    }

    public ApacheHttpRequest buildHeadRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpHead(url));
    }

    public ApacheHttpRequest buildPatchRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpPatch(url));
    }

    public ApacheHttpRequest buildPostRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpPost(url));
    }

    public ApacheHttpRequest buildPutRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpPut(url));
    }
}

