/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.storage;

import com.google.api.client.auth.HmacSha;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class GoogleStorageAuthentication {
    private static final String HOST = "commondatastorage.googleapis.com";

    public static void authorize(HttpTransport transport, String accessKey, String secret) {
        transport.removeIntercepters(Intercepter.class);
        Intercepter intercepter = new Intercepter();
        intercepter.accessKey = accessKey;
        intercepter.secret = secret;
        transport.intercepters.add(intercepter);
    }

    private GoogleStorageAuthentication() {
    }

    static class Intercepter
    implements HttpExecuteIntercepter {
        private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
        String accessKey;
        String secret;

        Intercepter() {
        }

        public void intercept(HttpRequest request) throws IOException {
            String bucket;
            HttpHeaders headers = request.headers;
            StringBuilder messageBuf = new StringBuilder();
            messageBuf.append(request.method).append('\n');
            String contentMD5 = headers.contentMD5;
            if (contentMD5 != null) {
                messageBuf.append(contentMD5);
            }
            messageBuf.append('\n');
            HttpContent content = request.content;
            if (content != null) {
                String contentType = content.getType();
                messageBuf.append(contentType);
            }
            messageBuf.append('\n');
            String date = headers.date;
            if (date != null) {
                messageBuf.append(headers.date);
            }
            messageBuf.append('\n');
            TreeMap<String, String> extensions = new TreeMap<String, String>();
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                String name = entry.getKey().toLowerCase();
                Object value = entry.getValue();
                if (value == null || !name.startsWith("x-goog-")) continue;
                if (value instanceof Collection) {
                    Collection collectionValue = (Collection)value;
                    StringBuilder buf = new StringBuilder();
                    boolean first = true;
                    for (Object repeatedValue : collectionValue) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(',');
                        }
                        buf.append(WHITESPACE_PATTERN.matcher(repeatedValue.toString()).replaceAll(" "));
                    }
                    extensions.put(name, buf.toString());
                    continue;
                }
                extensions.put(name, WHITESPACE_PATTERN.matcher(value.toString()).replaceAll(" "));
            }
            for (Map.Entry<String, Object> entry : extensions.entrySet()) {
                messageBuf.append(entry.getKey()).append(':').append((String)entry.getValue()).append('\n');
            }
            GenericUrl url = request.url;
            String string = url.host;
            if (!string.endsWith(GoogleStorageAuthentication.HOST)) {
                throw new IllegalArgumentException("missing host commondatastorage.googleapis.com");
            }
            int bucketNameLength = string.length() - GoogleStorageAuthentication.HOST.length() - 1;
            if (bucketNameLength > 0 && !(bucket = string.substring(0, bucketNameLength)).equals("c")) {
                messageBuf.append('/').append(bucket);
            }
            if (url.get("acl") != null) {
                messageBuf.append("?acl");
            } else if (url.get("location") != null) {
                messageBuf.append("?location");
            } else if (url.get("logging") != null) {
                messageBuf.append("?logging");
            } else if (url.get("requestPayment") != null) {
                messageBuf.append("?requestPayment");
            } else if (url.get("torrent") != null) {
                messageBuf.append("?torrent");
            }
            messageBuf.append(url.getRawPath());
            try {
                request.headers.authorization = "GOOG1 " + this.accessKey + ":" + HmacSha.sign(this.secret, messageBuf.toString());
            }
            catch (GeneralSecurityException e) {
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
        }
    }
}

