/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.GoogleTransport;
import com.google.api.client.googleapis.json.JsonCParser;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.Json;
import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;

public final class DiscoveryDocument {
    public final APIDefinition apiDefinition = new APIDefinition();

    private DiscoveryDocument() {
    }

    public static DiscoveryDocument load(String apiName) throws IOException {
        GenericUrl discoveryUrl = new GenericUrl("http://www.googleapis.com/discovery/0.1/describe");
        discoveryUrl.put("api", (Object)apiName);
        HttpTransport transport = GoogleTransport.create();
        HttpRequest request = transport.buildGetRequest();
        request.url = discoveryUrl;
        JsonParser parser = JsonCParser.parserForResponse(request.execute());
        Json.skipToKey(parser, apiName);
        DiscoveryDocument result = new DiscoveryDocument();
        APIDefinition apiDefinition = result.apiDefinition;
        Json.parseAndClose(parser, apiDefinition, null);
        return result;
    }

    public static final class ServiceParameter {
        @Key
        public boolean required;
    }

    public static final class ServiceMethod {
        @Key
        public String pathUrl;
        @Key
        public String httpMethod;
        @Key
        public Map<String, ServiceParameter> parameters;
        @Key
        public final String methodType = "rest";
    }

    public static final class ServiceResource {
        @Key
        public Map<String, ServiceMethod> methods;
    }

    public static final class ServiceDefinition {
        @Key
        public String baseUrl;
        @Key
        public Map<String, ServiceResource> resources;

        public ServiceMethod getResourceMethod(String methodIdentifier) {
            int dot = methodIdentifier.indexOf(46);
            String resourceName = methodIdentifier.substring(0, dot);
            String methodName = methodIdentifier.substring(dot + 1);
            ServiceResource resource = this.resources.get(resourceName);
            return resource == null ? null : resource.methods.get(methodName);
        }

        String getResourceUrl(String methodIdentifier) {
            return this.baseUrl + this.getResourceMethod((String)methodIdentifier).pathUrl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class APIDefinition
    extends ArrayMap<String, ServiceDefinition> {
    }
}

