/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.xml.atom;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.api.client.xml.atom.AbstractAtomFeedParser;
import com.google.api.client.xml.atom.Atom;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiKindFeedParser<T>
extends AbstractAtomFeedParser<T> {
    private final HashMap<String, Class<?>> kindToEntryClassMap = new HashMap();

    public void setEntryClasses(Class<?> ... entryClasses) {
        int numEntries = entryClasses.length;
        HashMap<String, Class<?>> kindToEntryClassMap = this.kindToEntryClassMap;
        for (int i = 0; i < numEntries; ++i) {
            Class<?> entryClass = entryClasses[i];
            ClassInfo typeInfo = ClassInfo.of(entryClass);
            Field field = typeInfo.getField("@gd:kind");
            if (field == null) {
                throw new IllegalArgumentException("missing @gd:kind field for " + entryClass.getName());
            }
            Object entry = ClassInfo.newInstance(entryClass);
            String kind = (String)FieldInfo.getFieldValue(field, entry);
            if (kind == null) {
                throw new IllegalArgumentException("missing value for @gd:kind field in " + entryClass.getName());
            }
            kindToEntryClassMap.put(kind, entryClass);
        }
    }

    @Override
    protected Object parseEntryInternal() throws IOException, XmlPullParserException {
        XmlPullParser parser = this.parser;
        String kind = parser.getAttributeValue("http://schemas.google.com/g/2005", "kind");
        Class<?> entryClass = this.kindToEntryClassMap.get(kind);
        if (entryClass == null) {
            throw new IllegalArgumentException("unrecognized kind: " + kind);
        }
        Object result = ClassInfo.newInstance(entryClass);
        Xml.parseElement(parser, result, this.namespaceDictionary, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, I> MultiKindFeedParser<T> create(HttpResponse response, XmlNamespaceDictionary namespaceDictionary, Class<T> feedClass, Class<?> ... entryClasses) throws XmlPullParserException, IOException {
        InputStream content = response.getContent();
        try {
            Atom.checkContentType(response.contentType);
            XmlPullParser parser = Xml.createParser();
            parser.setInput(content, null);
            MultiKindFeedParser<T> result = new MultiKindFeedParser<T>();
            result.parser = parser;
            result.inputStream = content;
            result.feedClass = feedClass;
            result.namespaceDictionary = namespaceDictionary;
            result.setEntryClasses(entryClasses);
            MultiKindFeedParser<T> multiKindFeedParser = result;
            return multiKindFeedParser;
        }
        finally {
            content.close();
        }
    }
}

