/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.escape.CharEscapers;
import com.google.api.client.http.HttpContent;
import com.google.api.client.util.DataUtil;
import com.google.api.client.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;

public final class UrlEncodedContent
implements HttpContent {
    public String contentType = "application/x-www-form-urlencoded";
    public Object data;
    private byte[] content;

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        return this.computeContent().length;
    }

    public String getType() {
        return this.contentType;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.computeContent());
    }

    private byte[] computeContent() {
        if (this.content == null) {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, Object> nameValueEntry : DataUtil.mapOf(this.data).entrySet()) {
                Object value = nameValueEntry.getValue();
                if (value == null) continue;
                String name = CharEscapers.escapeUri(nameValueEntry.getKey());
                if (value instanceof Collection) {
                    Collection collectionValue = (Collection)value;
                    for (Object repeatedValue : collectionValue) {
                        first = UrlEncodedContent.appendParam(first, buf, name, repeatedValue);
                    }
                    continue;
                }
                first = UrlEncodedContent.appendParam(first, buf, name, value);
            }
            this.content = Strings.toBytesUtf8(buf.toString());
        }
        return this.content;
    }

    private static boolean appendParam(boolean first, StringBuilder buf, String name, Object value) {
        if (first) {
            first = false;
        } else {
            buf.append('&');
        }
        buf.append(name);
        String stringValue = CharEscapers.escapeUri(value.toString());
        if (stringValue.length() != 0) {
            buf.append('=').append(stringValue);
        }
        return first;
    }
}

