/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml;

import com.google.api.client.util.DataUtil;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.xml.Xml;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlNamespaceDictionary {
    public final HashMap<String, String> namespaceAliasToUriMap = new HashMap();

    public void addNamespace(String alias, String uri) {
        if (alias == null || uri == null) {
            throw new NullPointerException();
        }
        HashMap<String, String> namespaceAliasToUriMap = this.namespaceAliasToUriMap;
        String knownUri = namespaceAliasToUriMap.get(alias);
        if (!uri.equals(knownUri)) {
            if (knownUri != null) {
                throw new IllegalArgumentException("expected namespace alias <" + alias + "> to be <" + knownUri + "> but encountered <" + uri + ">");
            }
            namespaceAliasToUriMap.put(alias, uri);
        }
    }

    public String toStringOf(String elementName, Object element) {
        try {
            StringWriter writer = new StringWriter();
            XmlSerializer serializer = Xml.createSerializer();
            serializer.setOutput((Writer)writer);
            this.serialize(serializer, elementName, element, false);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void serialize(XmlSerializer serializer, String elementNamespaceUri, String elementLocalName, Object element) throws IOException {
        this.serialize(serializer, elementNamespaceUri, elementLocalName, element, true);
    }

    public void serialize(XmlSerializer serializer, String elementName, Object element) throws IOException {
        this.serialize(serializer, elementName, element, true);
    }

    private void serialize(XmlSerializer serializer, String elementNamespaceUri, String elementLocalName, Object element, boolean errorOnUnknown) throws IOException {
        this.startDoc(serializer, element, errorOnUnknown, elementNamespaceUri).serialize(serializer, elementNamespaceUri, elementLocalName);
        serializer.endDocument();
    }

    private void serialize(XmlSerializer serializer, String elementName, Object element, boolean errorOnUnknown) throws IOException {
        this.startDoc(serializer, element, errorOnUnknown, null).serialize(serializer, elementName);
        serializer.endDocument();
    }

    private ElementSerializer startDoc(XmlSerializer serializer, Object element, boolean errorOnUnknown, String extraNamespace) throws IOException {
        serializer.startDocument(null, null);
        TreeSet<String> aliases = new TreeSet<String>();
        this.computeAliases(element, aliases);
        HashMap<String, String> namespaceAliasToUriMap = this.namespaceAliasToUriMap;
        boolean foundExtra = extraNamespace == null;
        for (String string : aliases) {
            String uri = namespaceAliasToUriMap.get(string);
            serializer.setPrefix(string, uri);
            if (foundExtra || !uri.equals(extraNamespace)) continue;
            foundExtra = true;
        }
        if (!foundExtra) {
            for (Map.Entry entry : namespaceAliasToUriMap.entrySet()) {
                if (!extraNamespace.equals(entry.getValue())) continue;
                serializer.setPrefix((String)entry.getKey(), extraNamespace);
                break;
            }
        }
        return new ElementSerializer(element, errorOnUnknown);
    }

    private void computeAliases(Object element, SortedSet<String> aliases) {
        for (Map.Entry<String, Object> entry : DataUtil.mapOf(element).entrySet()) {
            boolean isAttribute;
            String name;
            Object value = entry.getValue();
            if (value == null || "text()".equals(name = entry.getKey())) continue;
            int colon = name.indexOf(58);
            boolean bl = isAttribute = name.charAt(0) == '@';
            if (colon != -1 || !isAttribute) {
                String alias = colon == -1 ? "" : name.substring(name.charAt(0) == '@' ? 1 : 0, colon);
                aliases.add(alias);
            }
            if (isAttribute || FieldInfo.isPrimitive(value)) continue;
            if (value instanceof Collection) {
                for (Object subValue : (Collection)value) {
                    this.computeAliases(subValue, aliases);
                }
                continue;
            }
            this.computeAliases(value, aliases);
        }
    }

    static String toSerializedValue(Object value) {
        if (value instanceof Float) {
            Float f = (Float)value;
            if (f.floatValue() == Float.POSITIVE_INFINITY) {
                return "INF";
            }
            if (f.floatValue() == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof DateTime) {
            return ((DateTime)value).toStringRfc3339();
        }
        throw new IllegalArgumentException("unrecognized value type: " + value.getClass());
    }

    class ElementSerializer {
        private final boolean errorOnUnknown;
        Object textValue = null;
        final List<String> attributeNames = new ArrayList<String>();
        final List<Object> attributeValues = new ArrayList<Object>();
        final List<String> subElementNames = new ArrayList<String>();
        final List<Object> subElementValues = new ArrayList<Object>();

        ElementSerializer(Object elementValue, boolean errorOnUnknown) {
            this.errorOnUnknown = errorOnUnknown;
            Class<?> valueClass = elementValue.getClass();
            if (FieldInfo.isPrimitive(valueClass)) {
                this.textValue = elementValue;
            } else {
                for (Map.Entry<String, Object> entry : DataUtil.mapOf(elementValue).entrySet()) {
                    Object fieldValue = entry.getValue();
                    if (fieldValue == null) continue;
                    String fieldName = entry.getKey();
                    if ("text()".equals(fieldName)) {
                        this.textValue = fieldValue;
                        continue;
                    }
                    if (fieldName.charAt(0) == '@') {
                        this.attributeNames.add(fieldName.substring(1));
                        this.attributeValues.add(fieldValue);
                        continue;
                    }
                    this.subElementNames.add(fieldName);
                    this.subElementValues.add(fieldValue);
                }
            }
        }

        String getNamespaceUriForAlias(String alias) {
            String result = XmlNamespaceDictionary.this.namespaceAliasToUriMap.get(alias);
            if (result == null) {
                if (this.errorOnUnknown) {
                    throw new IllegalArgumentException("unrecognized alias: " + (alias.length() == 0 ? "(default)" : alias));
                }
                return "http://unknown/" + alias;
            }
            return result;
        }

        void serialize(XmlSerializer serializer, String elementName) throws IOException {
            String elementLocalName = null;
            String elementNamespaceUri = null;
            if (elementName != null) {
                int colon = elementName.indexOf(58);
                elementLocalName = elementName.substring(colon + 1);
                String alias = colon == -1 ? "" : elementName.substring(0, colon);
                elementNamespaceUri = this.getNamespaceUriForAlias(alias);
                if (elementNamespaceUri == null) {
                    elementNamespaceUri = "http://unknown/" + alias;
                }
            }
            this.serialize(serializer, elementNamespaceUri, elementLocalName);
        }

        void serialize(XmlSerializer serializer, String elementNamespaceUri, String elementLocalName) throws IOException {
            boolean errorOnUnknown = this.errorOnUnknown;
            if (elementLocalName == null) {
                if (errorOnUnknown) {
                    throw new IllegalArgumentException("XML name not specified");
                }
                elementLocalName = "unknownName";
            }
            serializer.startTag(elementNamespaceUri, elementLocalName);
            List<String> attributeNames = this.attributeNames;
            List<Object> attributeValues = this.attributeValues;
            int num = attributeNames.size();
            for (int i = 0; i < num; ++i) {
                String attributeName = attributeNames.get(i);
                int colon = attributeName.indexOf(58);
                String attributeLocalName = attributeName.substring(colon + 1);
                String attributeNamespaceUri = colon == -1 ? null : this.getNamespaceUriForAlias(attributeName.substring(0, colon));
                serializer.attribute(attributeNamespaceUri, attributeLocalName, XmlNamespaceDictionary.toSerializedValue(attributeValues.get(i)));
            }
            Object textValue = this.textValue;
            if (textValue != null) {
                serializer.text(XmlNamespaceDictionary.toSerializedValue(textValue));
            }
            List<String> subElementNames = this.subElementNames;
            List<Object> subElementValues = this.subElementValues;
            num = subElementNames.size();
            for (int i = 0; i < num; ++i) {
                Object subElementValue = subElementValues.get(i);
                String subElementName = subElementNames.get(i);
                if (subElementValue instanceof Collection) {
                    for (Object subElement : (Collection)subElementValue) {
                        new ElementSerializer(subElement, errorOnUnknown).serialize(serializer, subElementName);
                    }
                    continue;
                }
                new ElementSerializer(subElementValue, errorOnUnknown).serialize(serializer, subElementName);
            }
            serializer.endTag(elementNamespaceUri, elementLocalName);
        }
    }
}

