/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GZipContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LogContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Strings;
import com.google.api.client.util.Types;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpRequest {
    public static final String USER_AGENT_SUFFIX = "Google-API-Java-Client/1.4.0-alpha";
    public HttpExecuteInterceptor interceptor;
    public HttpHeaders headers;
    public HttpHeaders responseHeaders;
    public int numRetries = 10;
    public boolean disableContentLogging;
    public HttpContent content;
    public final HttpTransport transport;
    public HttpMethod method;
    public GenericUrl url;
    public int connectTimeout = 20000;
    public int readTimeout = 20000;
    public HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler;
    private final Map<String, HttpParser> contentTypeToParserMap;
    public boolean enableGZipContent;

    HttpRequest(HttpTransport transport, HttpMethod method) {
        this.transport = transport;
        this.headers = transport.defaultHeaders.clone();
        this.responseHeaders = transport.defaultHeaders.clone();
        this.contentTypeToParserMap = transport.contentTypeToParserMap.clone();
        this.method = method;
    }

    @Deprecated
    public void setUrl(String encodedUrl) {
        this.url = new GenericUrl(encodedUrl);
    }

    public void addParser(HttpParser parser) {
        String contentType = HttpRequest.normalizeMediaType(parser.getContentType());
        this.contentTypeToParserMap.put(contentType, parser);
    }

    public final HttpParser getParser(String contentType) {
        contentType = HttpRequest.normalizeMediaType(contentType);
        return this.contentTypeToParserMap.get(contentType);
    }

    public HttpResponse execute() throws IOException {
        boolean requiresRetry = false;
        boolean retrySupported = false;
        Preconditions.checkArgument((this.numRetries >= 0 ? 1 : 0) != 0);
        int retriesRemaining = this.numRetries;
        HttpResponse response = null;
        Preconditions.checkNotNull((Object)((Object)this.method));
        Preconditions.checkNotNull((Object)this.url);
        do {
            LowLevelHttpRequest lowLevelHttpRequest;
            if (response != null) {
                response.ignore();
            }
            if (this.interceptor != null) {
                this.interceptor.intercept(this);
            }
            for (HttpExecuteIntercepter intercepter : this.transport.intercepters) {
                intercepter.intercept(this);
            }
            String urlString = this.url.build();
            switch (this.method) {
                case DELETE: {
                    lowLevelHttpRequest = this.transport.buildDeleteRequest(urlString);
                    break;
                }
                default: {
                    lowLevelHttpRequest = this.transport.buildGetRequest(urlString);
                    break;
                }
                case HEAD: {
                    Preconditions.checkArgument((boolean)this.transport.supportsHead(), (Object)"HTTP transport doesn't support HEAD");
                    lowLevelHttpRequest = this.transport.buildHeadRequest(urlString);
                    break;
                }
                case PATCH: {
                    Preconditions.checkArgument((boolean)this.transport.supportsPatch(), (Object)"HTTP transport doesn't support PATCH");
                    lowLevelHttpRequest = this.transport.buildPatchRequest(urlString);
                    break;
                }
                case POST: {
                    lowLevelHttpRequest = this.transport.buildPostRequest(urlString);
                    break;
                }
                case PUT: {
                    lowLevelHttpRequest = this.transport.buildPutRequest(urlString);
                }
            }
            Logger logger = HttpTransport.LOGGER;
            boolean loggable = logger.isLoggable(Level.CONFIG);
            StringBuilder logbuf = null;
            if (loggable) {
                logbuf = new StringBuilder();
                logbuf.append("-------------- REQUEST  --------------").append(Strings.LINE_SEPARATOR);
                logbuf.append((Object)this.method).append(' ').append(urlString).append(Strings.LINE_SEPARATOR);
            }
            this.headers.userAgent = this.headers.userAgent == null ? USER_AGENT_SUFFIX : this.headers.userAgent + " Google-API-Java-Client/1.4.0-alpha";
            HashSet<String> headerNames = new HashSet<String>();
            for (Map.Entry<String, Object> headerEntry : this.headers.entrySet()) {
                String name = headerEntry.getKey();
                String lowerCase = name.toLowerCase();
                Preconditions.checkArgument((boolean)headerNames.add(lowerCase), (String)"multiple headers of the same name (headers are case insensitive): %s", (Object[])new Object[]{lowerCase});
                Object value = headerEntry.getValue();
                if (value == null) continue;
                Class<?> valueClass = value.getClass();
                if (value instanceof Iterable || valueClass.isArray()) {
                    for (Object repeatedValue : Types.iterableOf(value)) {
                        HttpRequest.addHeader(logger, logbuf, lowLevelHttpRequest, name, repeatedValue);
                    }
                    continue;
                }
                HttpRequest.addHeader(logger, logbuf, lowLevelHttpRequest, name, value);
            }
            HttpContent content = this.content;
            if (content != null) {
                String contentEncoding = content.getEncoding();
                long contentLength = content.getLength();
                String contentType = content.getType();
                if (contentLength != 0L && contentEncoding == null && LogContent.isTextBasedContentType(contentType) && (loggable && !this.disableContentLogging || logger.isLoggable(Level.ALL))) {
                    content = new LogContent(content, contentType, contentEncoding, contentLength);
                }
                if (this.enableGZipContent) {
                    content = new GZipContent(content, contentType);
                    contentEncoding = content.getEncoding();
                    contentLength = content.getLength();
                }
                if (loggable) {
                    if (contentType != null) {
                        logbuf.append("Content-Type: " + contentType).append(Strings.LINE_SEPARATOR);
                    }
                    if (contentEncoding != null) {
                        logbuf.append("Content-Encoding: " + contentEncoding).append(Strings.LINE_SEPARATOR);
                    }
                    if (contentLength >= 0L) {
                        logbuf.append("Content-Length: " + contentLength).append(Strings.LINE_SEPARATOR);
                    }
                }
                lowLevelHttpRequest.setContent(content);
            }
            if (loggable) {
                logger.config(logbuf.toString());
            }
            lowLevelHttpRequest.setTimeout(this.connectTimeout, this.readTimeout);
            response = new HttpResponse(this, lowLevelHttpRequest.execute());
            retrySupported = retriesRemaining > 0 && (content == null || content.retrySupported());
            requiresRetry = false;
            if (!response.isSuccessStatusCode && this.unsuccessfulResponseHandler != null) {
                requiresRetry = this.unsuccessfulResponseHandler.handleResponse(this, response, retrySupported);
            }
            --retriesRemaining;
        } while (requiresRetry && retrySupported);
        if (!response.isSuccessStatusCode) {
            throw new HttpResponseException(response);
        }
        return response;
    }

    private static void addHeader(Logger logger, StringBuilder logbuf, LowLevelHttpRequest lowLevelHttpRequest, String name, Object value) {
        String stringValue;
        if (value == null || Data.isNull(value)) {
            return;
        }
        String string = stringValue = value instanceof Enum ? FieldInfo.of((Enum)value).getName() : value.toString();
        if (logbuf != null) {
            logbuf.append(name).append(": ");
            if ("Authorization".equals(name) && !logger.isLoggable(Level.ALL)) {
                logbuf.append("<Not Logged>");
            } else {
                logbuf.append(stringValue);
            }
            logbuf.append(Strings.LINE_SEPARATOR);
        }
        lowLevelHttpRequest.addHeader(name, stringValue);
    }

    public static String normalizeMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        int semicolon = mediaType.indexOf(59);
        return semicolon == -1 ? mediaType : mediaType.substring(0, semicolon);
    }
}

