/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.AutoValue_ResourceReference;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class ResourceReference {
    public abstract String resourceTypeString();

    public abstract boolean isChildType();

    public boolean isOnlyWildcard() {
        return this.resourceTypeString().equals("*");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceReference)) {
            return false;
        }
        ResourceReference other = (ResourceReference)o;
        return this.resourceTypeString().equals(other.resourceTypeString()) && this.isChildType() == other.isChildType() && this.isOnlyWildcard() == other.isOnlyWildcard();
    }

    public int hashCode() {
        return 17 * this.resourceTypeString().hashCode() + (this.isChildType() ? 1 : 0) * 19 + (this.isOnlyWildcard() ? 1 : 0) * 31;
    }

    public static ResourceReference withType(String resourceTypeString) {
        return ResourceReference.builder().setResourceTypeString(resourceTypeString).setIsChildType(false).build();
    }

    public static ResourceReference withChildType(String resourceTypeString) {
        return ResourceReference.builder().setResourceTypeString(resourceTypeString).setIsChildType(true).build();
    }

    static Builder builder() {
        return new AutoValue_ResourceReference.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setResourceTypeString(String var1);

        abstract Builder setIsChildType(boolean var1);

        abstract ResourceReference build();
    }
}

