/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_AssignmentOperationExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.OperationExpr;
import com.google.api.generator.engine.ast.OperatorKind;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class AssignmentOperationExpr
implements OperationExpr {
    public abstract VariableExpr variableExpr();

    public abstract Expr valueExpr();

    @Override
    public abstract OperatorKind operatorKind();

    @Override
    public TypeNode type() {
        return this.variableExpr().type();
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static AssignmentOperationExpr xorAssignmentWithExprs(VariableExpr variableExpr, Expr valueExpr) {
        return AssignmentOperationExpr.builder().setVariableExpr(variableExpr).setValueExpr(valueExpr).setOperatorKind(OperatorKind.ASSIGNMENT_XOR).build();
    }

    public static AssignmentOperationExpr multiplyAssignmentWithExprs(VariableExpr variableExpr, Expr valueExpr) {
        return AssignmentOperationExpr.builder().setVariableExpr(variableExpr).setValueExpr(valueExpr).setOperatorKind(OperatorKind.ASSIGNMENT_MULTIPLY).build();
    }

    private static Builder builder() {
        return new AutoValue_AssignmentOperationExpr.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setVariableExpr(VariableExpr var1);

        abstract Builder setValueExpr(Expr var1);

        abstract Builder setOperatorKind(OperatorKind var1);

        abstract AssignmentOperationExpr autoBuild();

        private AssignmentOperationExpr build() {
            AssignmentOperationExpr assignmentOperationExpr = this.autoBuild();
            TypeNode lhsType = assignmentOperationExpr.variableExpr().variable().type();
            TypeNode rhsType = assignmentOperationExpr.valueExpr().type();
            OperatorKind operator = assignmentOperationExpr.operatorKind();
            Preconditions.checkState(!assignmentOperationExpr.variableExpr().isDecl(), String.format("Variable `%s` should not be declaration in the variable expression.", assignmentOperationExpr.variableExpr().variable().name()));
            String errorMsg = String.format("Assignment operator %s can not be applied to %s, %s.", new Object[]{operator, lhsType.toString(), rhsType.toString()});
            if (operator.equals((Object)OperatorKind.ASSIGNMENT_MULTIPLY)) {
                Preconditions.checkState(this.isValidMultiplyAssignmentType(lhsType, rhsType), errorMsg);
            }
            if (operator.equals((Object)OperatorKind.ASSIGNMENT_XOR)) {
                Preconditions.checkState(this.isValidXorAssignmentType(lhsType, rhsType), errorMsg);
            }
            return assignmentOperationExpr;
        }

        private boolean isValidMultiplyAssignmentType(TypeNode variableType, TypeNode valueType) {
            if (TypeNode.isNumericType(variableType) && !TypeNode.isBoxedType(variableType)) {
                return TypeNode.isNumericType(valueType);
            }
            if (variableType.equals(TypeNode.INT)) {
                return TypeNode.isNumericType(valueType) && !valueType.equals(TypeNode.LONG) && !TypeNode.isFloatingPointType(valueType);
            }
            if (variableType.equals(TypeNode.LONG)) {
                return TypeNode.isNumericType(valueType) && !TypeNode.isFloatingPointType(valueType);
            }
            if (variableType.equals(TypeNode.FLOAT)) {
                return TypeNode.isNumericType(valueType) && !valueType.equals(TypeNode.DOUBLE);
            }
            if (variableType.equals(TypeNode.DOUBLE)) {
                return TypeNode.isNumericType(valueType);
            }
            return false;
        }

        private boolean isValidXorAssignmentType(TypeNode variableType, TypeNode valueType) {
            if (variableType.equals(TypeNode.BOOLEAN)) {
                return valueType.equals(variableType);
            }
            if (variableType.equals(TypeNode.INT)) {
                return TypeNode.isNumericType(valueType) && !TypeNode.isFloatingPointType(valueType);
            }
            return TypeNode.isNumericType(variableType) && TypeNode.isNumericType(valueType) && !TypeNode.isFloatingPointType(variableType) && !TypeNode.isFloatingPointType(valueType) && !TypeNode.isBoxedType(variableType);
        }
    }
}

