package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AnonymousClassExpr extends AnonymousClassExpr {

  private final TypeNode type;

  private final ImmutableList<MethodDefinition> methods;

  private final ImmutableList<Statement> statements;

  private AutoValue_AnonymousClassExpr(
      TypeNode type,
      ImmutableList<MethodDefinition> methods,
      ImmutableList<Statement> statements) {
    this.type = type;
    this.methods = methods;
    this.statements = statements;
  }

  @Override
  public TypeNode type() {
    return type;
  }

  @Override
  public ImmutableList<MethodDefinition> methods() {
    return methods;
  }

  @Override
  public ImmutableList<Statement> statements() {
    return statements;
  }

  @Override
  public String toString() {
    return "AnonymousClassExpr{"
        + "type=" + type + ", "
        + "methods=" + methods + ", "
        + "statements=" + statements
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AnonymousClassExpr) {
      AnonymousClassExpr that = (AnonymousClassExpr) o;
      return this.type.equals(that.type())
          && this.methods.equals(that.methods())
          && this.statements.equals(that.statements());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= methods.hashCode();
    h$ *= 1000003;
    h$ ^= statements.hashCode();
    return h$;
  }

  static final class Builder extends AnonymousClassExpr.Builder {
    private TypeNode type;
    private ImmutableList<MethodDefinition> methods;
    private ImmutableList<Statement> statements;
    Builder() {
    }
    @Override
    public AnonymousClassExpr.Builder setType(TypeNode type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public AnonymousClassExpr.Builder setMethods(List<MethodDefinition> methods) {
      this.methods = ImmutableList.copyOf(methods);
      return this;
    }
    @Override
    public AnonymousClassExpr.Builder setStatements(List<Statement> statements) {
      this.statements = ImmutableList.copyOf(statements);
      return this;
    }
    @Override
    public AnonymousClassExpr autoBuild() {
      if (this.type == null
          || this.methods == null
          || this.statements == null) {
        StringBuilder missing = new StringBuilder();
        if (this.type == null) {
          missing.append(" type");
        }
        if (this.methods == null) {
          missing.append(" methods");
        }
        if (this.statements == null) {
          missing.append(" statements");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AnonymousClassExpr(
          this.type,
          this.methods,
          this.statements);
    }
  }

}
