package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BlockStatement extends BlockStatement {

  private final ImmutableList<Statement> body;

  private final boolean isStatic;

  private AutoValue_BlockStatement(
      ImmutableList<Statement> body,
      boolean isStatic) {
    this.body = body;
    this.isStatic = isStatic;
  }

  @Override
  public ImmutableList<Statement> body() {
    return body;
  }

  @Override
  public boolean isStatic() {
    return isStatic;
  }

  @Override
  public String toString() {
    return "BlockStatement{"
        + "body=" + body + ", "
        + "isStatic=" + isStatic
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BlockStatement) {
      BlockStatement that = (BlockStatement) o;
      return this.body.equals(that.body())
          && this.isStatic == that.isStatic();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= body.hashCode();
    h$ *= 1000003;
    h$ ^= isStatic ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends BlockStatement.Builder {
    private ImmutableList<Statement> body;
    private boolean isStatic;
    private byte set$0;
    Builder() {
    }
    @Override
    public BlockStatement.Builder setBody(List<Statement> body) {
      this.body = ImmutableList.copyOf(body);
      return this;
    }
    @Override
    public BlockStatement.Builder setIsStatic(boolean isStatic) {
      this.isStatic = isStatic;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    BlockStatement autoBuild() {
      if (set$0 != 1
          || this.body == null) {
        StringBuilder missing = new StringBuilder();
        if (this.body == null) {
          missing.append(" body");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isStatic");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BlockStatement(
          this.body,
          this.isStatic);
    }
  }

}
