package com.google.api.generator.engine.ast;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CastExpr extends CastExpr {

  private final TypeNode type;

  private final Expr expr;

  private AutoValue_CastExpr(
      TypeNode type,
      Expr expr) {
    this.type = type;
    this.expr = expr;
  }

  @Override
  public TypeNode type() {
    return type;
  }

  @Override
  public Expr expr() {
    return expr;
  }

  @Override
  public String toString() {
    return "CastExpr{"
        + "type=" + type + ", "
        + "expr=" + expr
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CastExpr) {
      CastExpr that = (CastExpr) o;
      return this.type.equals(that.type())
          && this.expr.equals(that.expr());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= expr.hashCode();
    return h$;
  }

  static final class Builder extends CastExpr.Builder {
    private TypeNode type;
    private Expr expr;
    Builder() {
    }
    @Override
    public CastExpr.Builder setType(TypeNode type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public CastExpr.Builder setExpr(Expr expr) {
      if (expr == null) {
        throw new NullPointerException("Null expr");
      }
      this.expr = expr;
      return this;
    }
    @Override
    CastExpr autoBuild() {
      if (this.type == null
          || this.expr == null) {
        StringBuilder missing = new StringBuilder();
        if (this.type == null) {
          missing.append(" type");
        }
        if (this.expr == null) {
          missing.append(" expr");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CastExpr(
          this.type,
          this.expr);
    }
  }

}
