package com.google.api.generator.engine.ast;

import com.google.api.generator.gapic.model.RegionTag;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ClassDefinition extends ClassDefinition {

  private final ImmutableList<CommentStatement> fileHeader;

  @Nullable
  private final RegionTag regionTag;

  private final ScopeNode scope;

  private final IdentifierNode classIdentifier;

  @Nullable
  private final String packageString;

  private final boolean isNested;

  private final ImmutableList<CommentStatement> headerCommentStatements;

  private final ImmutableList<AnnotationNode> annotations;

  private final ImmutableList<TypeNode> implementsTypes;

  @Nullable
  private final TypeNode extendsType;

  private final boolean isStatic;

  private final boolean isFinal;

  private final boolean isAbstract;

  private final ImmutableList<Statement> statements;

  private final ImmutableList<MethodDefinition> methods;

  private final ImmutableList<ClassDefinition> nestedClasses;

  private final String name;

  private AutoValue_ClassDefinition(
      ImmutableList<CommentStatement> fileHeader,
      @Nullable RegionTag regionTag,
      ScopeNode scope,
      IdentifierNode classIdentifier,
      @Nullable String packageString,
      boolean isNested,
      ImmutableList<CommentStatement> headerCommentStatements,
      ImmutableList<AnnotationNode> annotations,
      ImmutableList<TypeNode> implementsTypes,
      @Nullable TypeNode extendsType,
      boolean isStatic,
      boolean isFinal,
      boolean isAbstract,
      ImmutableList<Statement> statements,
      ImmutableList<MethodDefinition> methods,
      ImmutableList<ClassDefinition> nestedClasses,
      String name) {
    this.fileHeader = fileHeader;
    this.regionTag = regionTag;
    this.scope = scope;
    this.classIdentifier = classIdentifier;
    this.packageString = packageString;
    this.isNested = isNested;
    this.headerCommentStatements = headerCommentStatements;
    this.annotations = annotations;
    this.implementsTypes = implementsTypes;
    this.extendsType = extendsType;
    this.isStatic = isStatic;
    this.isFinal = isFinal;
    this.isAbstract = isAbstract;
    this.statements = statements;
    this.methods = methods;
    this.nestedClasses = nestedClasses;
    this.name = name;
  }

  @Override
  public ImmutableList<CommentStatement> fileHeader() {
    return fileHeader;
  }

  @Nullable
  @Override
  public RegionTag regionTag() {
    return regionTag;
  }

  @Override
  public ScopeNode scope() {
    return scope;
  }

  @Override
  public IdentifierNode classIdentifier() {
    return classIdentifier;
  }

  @Nullable
  @Override
  public String packageString() {
    return packageString;
  }

  @Override
  public boolean isNested() {
    return isNested;
  }

  @Override
  public ImmutableList<CommentStatement> headerCommentStatements() {
    return headerCommentStatements;
  }

  @Override
  public ImmutableList<AnnotationNode> annotations() {
    return annotations;
  }

  @Override
  public ImmutableList<TypeNode> implementsTypes() {
    return implementsTypes;
  }

  @Nullable
  @Override
  public TypeNode extendsType() {
    return extendsType;
  }

  @Override
  public boolean isStatic() {
    return isStatic;
  }

  @Override
  public boolean isFinal() {
    return isFinal;
  }

  @Override
  public boolean isAbstract() {
    return isAbstract;
  }

  @Override
  public ImmutableList<Statement> statements() {
    return statements;
  }

  @Override
  public ImmutableList<MethodDefinition> methods() {
    return methods;
  }

  @Override
  public ImmutableList<ClassDefinition> nestedClasses() {
    return nestedClasses;
  }

  @Override
  String name() {
    return name;
  }

  @Override
  public String toString() {
    return "ClassDefinition{"
        + "fileHeader=" + fileHeader + ", "
        + "regionTag=" + regionTag + ", "
        + "scope=" + scope + ", "
        + "classIdentifier=" + classIdentifier + ", "
        + "packageString=" + packageString + ", "
        + "isNested=" + isNested + ", "
        + "headerCommentStatements=" + headerCommentStatements + ", "
        + "annotations=" + annotations + ", "
        + "implementsTypes=" + implementsTypes + ", "
        + "extendsType=" + extendsType + ", "
        + "isStatic=" + isStatic + ", "
        + "isFinal=" + isFinal + ", "
        + "isAbstract=" + isAbstract + ", "
        + "statements=" + statements + ", "
        + "methods=" + methods + ", "
        + "nestedClasses=" + nestedClasses + ", "
        + "name=" + name
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ClassDefinition) {
      ClassDefinition that = (ClassDefinition) o;
      return this.fileHeader.equals(that.fileHeader())
          && (this.regionTag == null ? that.regionTag() == null : this.regionTag.equals(that.regionTag()))
          && this.scope.equals(that.scope())
          && this.classIdentifier.equals(that.classIdentifier())
          && (this.packageString == null ? that.packageString() == null : this.packageString.equals(that.packageString()))
          && this.isNested == that.isNested()
          && this.headerCommentStatements.equals(that.headerCommentStatements())
          && this.annotations.equals(that.annotations())
          && this.implementsTypes.equals(that.implementsTypes())
          && (this.extendsType == null ? that.extendsType() == null : this.extendsType.equals(that.extendsType()))
          && this.isStatic == that.isStatic()
          && this.isFinal == that.isFinal()
          && this.isAbstract == that.isAbstract()
          && this.statements.equals(that.statements())
          && this.methods.equals(that.methods())
          && this.nestedClasses.equals(that.nestedClasses())
          && this.name.equals(that.name());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fileHeader.hashCode();
    h$ *= 1000003;
    h$ ^= (regionTag == null) ? 0 : regionTag.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= classIdentifier.hashCode();
    h$ *= 1000003;
    h$ ^= (packageString == null) ? 0 : packageString.hashCode();
    h$ *= 1000003;
    h$ ^= isNested ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= headerCommentStatements.hashCode();
    h$ *= 1000003;
    h$ ^= annotations.hashCode();
    h$ *= 1000003;
    h$ ^= implementsTypes.hashCode();
    h$ *= 1000003;
    h$ ^= (extendsType == null) ? 0 : extendsType.hashCode();
    h$ *= 1000003;
    h$ ^= isStatic ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isFinal ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isAbstract ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= statements.hashCode();
    h$ *= 1000003;
    h$ ^= methods.hashCode();
    h$ *= 1000003;
    h$ ^= nestedClasses.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    return h$;
  }

  @Override
  public ClassDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ClassDefinition.Builder {
    private ImmutableList<CommentStatement> fileHeader;
    private RegionTag regionTag;
    private ScopeNode scope;
    private IdentifierNode classIdentifier;
    private String packageString;
    private boolean isNested;
    private ImmutableList<CommentStatement> headerCommentStatements;
    private ImmutableList<AnnotationNode> annotations;
    private ImmutableList<TypeNode> implementsTypes;
    private TypeNode extendsType;
    private boolean isStatic;
    private boolean isFinal;
    private boolean isAbstract;
    private ImmutableList<Statement> statements;
    private ImmutableList<MethodDefinition> methods;
    private ImmutableList<ClassDefinition> nestedClasses;
    private String name;
    private byte set$0;
    Builder() {
    }
    private Builder(ClassDefinition source) {
      this.fileHeader = source.fileHeader();
      this.regionTag = source.regionTag();
      this.scope = source.scope();
      this.classIdentifier = source.classIdentifier();
      this.packageString = source.packageString();
      this.isNested = source.isNested();
      this.headerCommentStatements = source.headerCommentStatements();
      this.annotations = source.annotations();
      this.implementsTypes = source.implementsTypes();
      this.extendsType = source.extendsType();
      this.isStatic = source.isStatic();
      this.isFinal = source.isFinal();
      this.isAbstract = source.isAbstract();
      this.statements = source.statements();
      this.methods = source.methods();
      this.nestedClasses = source.nestedClasses();
      this.name = source.name();
      set$0 = (byte) 0xf;
    }
    @Override
    public ClassDefinition.Builder setFileHeader(List<CommentStatement> fileHeader) {
      this.fileHeader = ImmutableList.copyOf(fileHeader);
      return this;
    }
    @Override
    public ClassDefinition.Builder setRegionTag(RegionTag regionTag) {
      this.regionTag = regionTag;
      return this;
    }
    @Override
    public ClassDefinition.Builder setScope(ScopeNode scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    ClassDefinition.Builder setClassIdentifier(IdentifierNode classIdentifier) {
      if (classIdentifier == null) {
        throw new NullPointerException("Null classIdentifier");
      }
      this.classIdentifier = classIdentifier;
      return this;
    }
    @Override
    public ClassDefinition.Builder setPackageString(String packageString) {
      this.packageString = packageString;
      return this;
    }
    @Override
    public ClassDefinition.Builder setIsNested(boolean isNested) {
      this.isNested = isNested;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public ClassDefinition.Builder setHeaderCommentStatements(List<CommentStatement> headerCommentStatements) {
      this.headerCommentStatements = ImmutableList.copyOf(headerCommentStatements);
      return this;
    }
    @Override
    public ClassDefinition.Builder setAnnotations(List<AnnotationNode> annotations) {
      this.annotations = ImmutableList.copyOf(annotations);
      return this;
    }
    @Override
    public ClassDefinition.Builder setImplementsTypes(List<TypeNode> implementsTypes) {
      this.implementsTypes = ImmutableList.copyOf(implementsTypes);
      return this;
    }
    @Override
    public ClassDefinition.Builder setExtendsType(TypeNode extendsType) {
      this.extendsType = extendsType;
      return this;
    }
    @Override
    public ClassDefinition.Builder setIsStatic(boolean isStatic) {
      this.isStatic = isStatic;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public ClassDefinition.Builder setIsFinal(boolean isFinal) {
      this.isFinal = isFinal;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public ClassDefinition.Builder setIsAbstract(boolean isAbstract) {
      this.isAbstract = isAbstract;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public ClassDefinition.Builder setStatements(List<Statement> statements) {
      this.statements = ImmutableList.copyOf(statements);
      return this;
    }
    @Override
    public ClassDefinition.Builder setMethods(List<MethodDefinition> methods) {
      this.methods = ImmutableList.copyOf(methods);
      return this;
    }
    @Override
    public ClassDefinition.Builder setNestedClasses(List<ClassDefinition> nestedClasses) {
      this.nestedClasses = ImmutableList.copyOf(nestedClasses);
      return this;
    }
    @Override
    public ClassDefinition.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    String name() {
      if (this.name == null) {
        throw new IllegalStateException("Property \"name\" has not been set");
      }
      return name;
    }
    @Override
    ClassDefinition autoBuild() {
      if (set$0 != 0xf
          || this.fileHeader == null
          || this.scope == null
          || this.classIdentifier == null
          || this.headerCommentStatements == null
          || this.annotations == null
          || this.implementsTypes == null
          || this.statements == null
          || this.methods == null
          || this.nestedClasses == null
          || this.name == null) {
        StringBuilder missing = new StringBuilder();
        if (this.fileHeader == null) {
          missing.append(" fileHeader");
        }
        if (this.scope == null) {
          missing.append(" scope");
        }
        if (this.classIdentifier == null) {
          missing.append(" classIdentifier");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isNested");
        }
        if (this.headerCommentStatements == null) {
          missing.append(" headerCommentStatements");
        }
        if (this.annotations == null) {
          missing.append(" annotations");
        }
        if (this.implementsTypes == null) {
          missing.append(" implementsTypes");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" isStatic");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" isFinal");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" isAbstract");
        }
        if (this.statements == null) {
          missing.append(" statements");
        }
        if (this.methods == null) {
          missing.append(" methods");
        }
        if (this.nestedClasses == null) {
          missing.append(" nestedClasses");
        }
        if (this.name == null) {
          missing.append(" name");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ClassDefinition(
          this.fileHeader,
          this.regionTag,
          this.scope,
          this.classIdentifier,
          this.packageString,
          this.isNested,
          this.headerCommentStatements,
          this.annotations,
          this.implementsTypes,
          this.extendsType,
          this.isStatic,
          this.isFinal,
          this.isAbstract,
          this.statements,
          this.methods,
          this.nestedClasses,
          this.name);
    }
  }

}
