package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConcreteReference extends ConcreteReference {

  private final Class<?> clazz;

  @Nullable
  private final Reference wildcardUpperBound;

  private final ImmutableList<Reference> generics;

  private final boolean isStaticImport;

  private final boolean useFullName;

  private AutoValue_ConcreteReference(
      Class<?> clazz,
      @Nullable Reference wildcardUpperBound,
      ImmutableList<Reference> generics,
      boolean isStaticImport,
      boolean useFullName) {
    this.clazz = clazz;
    this.wildcardUpperBound = wildcardUpperBound;
    this.generics = generics;
    this.isStaticImport = isStaticImport;
    this.useFullName = useFullName;
  }

  @Override
  Class<?> clazz() {
    return clazz;
  }

  @Nullable
  @Override
  public Reference wildcardUpperBound() {
    return wildcardUpperBound;
  }

  @Override
  public ImmutableList<Reference> generics() {
    return generics;
  }

  @Override
  public boolean isStaticImport() {
    return isStaticImport;
  }

  @Override
  public boolean useFullName() {
    return useFullName;
  }

  @Override
  public String toString() {
    return "ConcreteReference{"
        + "clazz=" + clazz + ", "
        + "wildcardUpperBound=" + wildcardUpperBound + ", "
        + "generics=" + generics + ", "
        + "isStaticImport=" + isStaticImport + ", "
        + "useFullName=" + useFullName
        + "}";
  }

  @Override
  ConcreteReference.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ConcreteReference.Builder {
    private Class<?> clazz;
    private Reference wildcardUpperBound;
    private ImmutableList<Reference> generics;
    private boolean isStaticImport;
    private boolean useFullName;
    private byte set$0;
    Builder() {
    }
    private Builder(ConcreteReference source) {
      this.clazz = source.clazz();
      this.wildcardUpperBound = source.wildcardUpperBound();
      this.generics = source.generics();
      this.isStaticImport = source.isStaticImport();
      this.useFullName = source.useFullName();
      set$0 = (byte) 3;
    }
    @Override
    public ConcreteReference.Builder setClazz(Class<?> clazz) {
      if (clazz == null) {
        throw new NullPointerException("Null clazz");
      }
      this.clazz = clazz;
      return this;
    }
    @Override
    Class<?> clazz() {
      if (this.clazz == null) {
        throw new IllegalStateException("Property \"clazz\" has not been set");
      }
      return clazz;
    }
    @Override
    public ConcreteReference.Builder setWildcardUpperBound(Reference wildcardUpperBound) {
      this.wildcardUpperBound = wildcardUpperBound;
      return this;
    }
    @Override
    public ConcreteReference.Builder setGenerics(List<Reference> generics) {
      this.generics = ImmutableList.copyOf(generics);
      return this;
    }
    @Override
    ImmutableList<Reference> generics() {
      if (this.generics == null) {
        throw new IllegalStateException("Property \"generics\" has not been set");
      }
      return generics;
    }
    @Override
    public ConcreteReference.Builder setIsStaticImport(boolean isStaticImport) {
      this.isStaticImport = isStaticImport;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    boolean isStaticImport() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"isStaticImport\" has not been set");
      }
      return isStaticImport;
    }
    @Override
    public ConcreteReference.Builder setUseFullName(boolean useFullName) {
      this.useFullName = useFullName;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public ConcreteReference autoBuild() {
      if (set$0 != 3
          || this.clazz == null
          || this.generics == null) {
        StringBuilder missing = new StringBuilder();
        if (this.clazz == null) {
          missing.append(" clazz");
        }
        if (this.generics == null) {
          missing.append(" generics");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isStaticImport");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" useFullName");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConcreteReference(
          this.clazz,
          this.wildcardUpperBound,
          this.generics,
          this.isStaticImport,
          this.useFullName);
    }
  }

}
