package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ForStatement extends ForStatement {

  private final VariableExpr localVariableExpr;

  private final Expr collectionExpr;

  private final ImmutableList<Statement> body;

  private AutoValue_ForStatement(
      VariableExpr localVariableExpr,
      Expr collectionExpr,
      ImmutableList<Statement> body) {
    this.localVariableExpr = localVariableExpr;
    this.collectionExpr = collectionExpr;
    this.body = body;
  }

  @Override
  public VariableExpr localVariableExpr() {
    return localVariableExpr;
  }

  @Override
  public Expr collectionExpr() {
    return collectionExpr;
  }

  @Override
  public ImmutableList<Statement> body() {
    return body;
  }

  @Override
  public String toString() {
    return "ForStatement{"
        + "localVariableExpr=" + localVariableExpr + ", "
        + "collectionExpr=" + collectionExpr + ", "
        + "body=" + body
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ForStatement) {
      ForStatement that = (ForStatement) o;
      return this.localVariableExpr.equals(that.localVariableExpr())
          && this.collectionExpr.equals(that.collectionExpr())
          && this.body.equals(that.body());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= localVariableExpr.hashCode();
    h$ *= 1000003;
    h$ ^= collectionExpr.hashCode();
    h$ *= 1000003;
    h$ ^= body.hashCode();
    return h$;
  }

  static final class Builder extends ForStatement.Builder {
    private VariableExpr localVariableExpr;
    private Expr collectionExpr;
    private ImmutableList<Statement> body;
    Builder() {
    }
    @Override
    public ForStatement.Builder setLocalVariableExpr(VariableExpr localVariableExpr) {
      if (localVariableExpr == null) {
        throw new NullPointerException("Null localVariableExpr");
      }
      this.localVariableExpr = localVariableExpr;
      return this;
    }
    @Override
    public ForStatement.Builder setCollectionExpr(Expr collectionExpr) {
      if (collectionExpr == null) {
        throw new NullPointerException("Null collectionExpr");
      }
      this.collectionExpr = collectionExpr;
      return this;
    }
    @Override
    public ForStatement.Builder setBody(List<Statement> body) {
      this.body = ImmutableList.copyOf(body);
      return this;
    }
    @Override
    ForStatement autoBuild() {
      if (this.localVariableExpr == null
          || this.collectionExpr == null
          || this.body == null) {
        StringBuilder missing = new StringBuilder();
        if (this.localVariableExpr == null) {
          missing.append(" localVariableExpr");
        }
        if (this.collectionExpr == null) {
          missing.append(" collectionExpr");
        }
        if (this.body == null) {
          missing.append(" body");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ForStatement(
          this.localVariableExpr,
          this.collectionExpr,
          this.body);
    }
  }

}
