package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IfStatement extends IfStatement {

  private final Expr conditionExpr;

  private final ImmutableList<Statement> body;

  private final ImmutableMap<Expr, List<Statement>> elseIfs;

  private final ImmutableList<Statement> elseBody;

  private AutoValue_IfStatement(
      Expr conditionExpr,
      ImmutableList<Statement> body,
      ImmutableMap<Expr, List<Statement>> elseIfs,
      ImmutableList<Statement> elseBody) {
    this.conditionExpr = conditionExpr;
    this.body = body;
    this.elseIfs = elseIfs;
    this.elseBody = elseBody;
  }

  @Override
  public Expr conditionExpr() {
    return conditionExpr;
  }

  @Override
  public ImmutableList<Statement> body() {
    return body;
  }

  @Override
  public ImmutableMap<Expr, List<Statement>> elseIfs() {
    return elseIfs;
  }

  @Override
  public ImmutableList<Statement> elseBody() {
    return elseBody;
  }

  @Override
  public String toString() {
    return "IfStatement{"
        + "conditionExpr=" + conditionExpr + ", "
        + "body=" + body + ", "
        + "elseIfs=" + elseIfs + ", "
        + "elseBody=" + elseBody
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IfStatement) {
      IfStatement that = (IfStatement) o;
      return this.conditionExpr.equals(that.conditionExpr())
          && this.body.equals(that.body())
          && this.elseIfs.equals(that.elseIfs())
          && this.elseBody.equals(that.elseBody());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= conditionExpr.hashCode();
    h$ *= 1000003;
    h$ ^= body.hashCode();
    h$ *= 1000003;
    h$ ^= elseIfs.hashCode();
    h$ *= 1000003;
    h$ ^= elseBody.hashCode();
    return h$;
  }

  static final class Builder extends IfStatement.Builder {
    private Expr conditionExpr;
    private ImmutableList<Statement> body;
    private ImmutableMap.Builder<Expr, List<Statement>> elseIfsBuilder$;
    private ImmutableMap<Expr, List<Statement>> elseIfs;
    private ImmutableList<Statement> elseBody;
    Builder() {
    }
    @Override
    public IfStatement.Builder setConditionExpr(Expr conditionExpr) {
      if (conditionExpr == null) {
        throw new NullPointerException("Null conditionExpr");
      }
      this.conditionExpr = conditionExpr;
      return this;
    }
    @Override
    public IfStatement.Builder setBody(List<Statement> body) {
      this.body = ImmutableList.copyOf(body);
      return this;
    }
    @Override
    IfStatement.Builder setElseIfs(ImmutableMap<Expr, List<Statement>> elseIfs) {
      if (elseIfs == null) {
        throw new NullPointerException("Null elseIfs");
      }
      if (elseIfsBuilder$ != null) {
        throw new IllegalStateException("Cannot set elseIfs after calling elseIfsBuilder()");
      }
      this.elseIfs = elseIfs;
      return this;
    }
    @Override
    ImmutableMap.Builder<Expr, List<Statement>> elseIfsBuilder() {
      if (elseIfsBuilder$ == null) {
        if (elseIfs == null) {
          elseIfsBuilder$ = ImmutableMap.builder();
        } else {
          elseIfsBuilder$ = ImmutableMap.builder();
          elseIfsBuilder$.putAll(elseIfs);
          elseIfs = null;
        }
      }
      return elseIfsBuilder$;
    }
    @Override
    public IfStatement.Builder setElseBody(List<Statement> elseBody) {
      this.elseBody = ImmutableList.copyOf(elseBody);
      return this;
    }
    @Override
    IfStatement autoBuild() {
      if (elseIfsBuilder$ != null) {
        this.elseIfs = elseIfsBuilder$.buildOrThrow();
      } else if (this.elseIfs == null) {
        this.elseIfs = ImmutableMap.of();
      }
      if (this.conditionExpr == null
          || this.body == null
          || this.elseBody == null) {
        StringBuilder missing = new StringBuilder();
        if (this.conditionExpr == null) {
          missing.append(" conditionExpr");
        }
        if (this.body == null) {
          missing.append(" body");
        }
        if (this.elseBody == null) {
          missing.append(" elseBody");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IfStatement(
          this.conditionExpr,
          this.body,
          this.elseIfs,
          this.elseBody);
    }
  }

}
