package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LambdaExpr extends LambdaExpr {

  private final ImmutableList<VariableExpr> arguments;

  private final ReturnExpr returnExpr;

  private final ImmutableList<Statement> body;

  private AutoValue_LambdaExpr(
      ImmutableList<VariableExpr> arguments,
      ReturnExpr returnExpr,
      ImmutableList<Statement> body) {
    this.arguments = arguments;
    this.returnExpr = returnExpr;
    this.body = body;
  }

  @Override
  public ImmutableList<VariableExpr> arguments() {
    return arguments;
  }

  @Override
  public ReturnExpr returnExpr() {
    return returnExpr;
  }

  @Override
  public ImmutableList<Statement> body() {
    return body;
  }

  @Override
  public String toString() {
    return "LambdaExpr{"
        + "arguments=" + arguments + ", "
        + "returnExpr=" + returnExpr + ", "
        + "body=" + body
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LambdaExpr) {
      LambdaExpr that = (LambdaExpr) o;
      return this.arguments.equals(that.arguments())
          && this.returnExpr.equals(that.returnExpr())
          && this.body.equals(that.body());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= arguments.hashCode();
    h$ *= 1000003;
    h$ ^= returnExpr.hashCode();
    h$ *= 1000003;
    h$ ^= body.hashCode();
    return h$;
  }

  static final class Builder extends LambdaExpr.Builder {
    private ImmutableList<VariableExpr> arguments;
    private ReturnExpr returnExpr;
    private ImmutableList<Statement> body;
    Builder() {
    }
    @Override
    public LambdaExpr.Builder setArguments(List<VariableExpr> arguments) {
      this.arguments = ImmutableList.copyOf(arguments);
      return this;
    }
    @Override
    public LambdaExpr.Builder setReturnExpr(ReturnExpr returnExpr) {
      if (returnExpr == null) {
        throw new NullPointerException("Null returnExpr");
      }
      this.returnExpr = returnExpr;
      return this;
    }
    @Override
    public LambdaExpr.Builder setBody(List<Statement> body) {
      this.body = ImmutableList.copyOf(body);
      return this;
    }
    @Override
    public LambdaExpr autoBuild() {
      if (this.arguments == null
          || this.returnExpr == null
          || this.body == null) {
        StringBuilder missing = new StringBuilder();
        if (this.arguments == null) {
          missing.append(" arguments");
        }
        if (this.returnExpr == null) {
          missing.append(" returnExpr");
        }
        if (this.body == null) {
          missing.append(" body");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LambdaExpr(
          this.arguments,
          this.returnExpr,
          this.body);
    }
  }

}
