package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MethodDefinition extends MethodDefinition {

  private final ScopeNode scope;

  private final TypeNode returnType;

  private final IdentifierNode methodIdentifier;

  private final ImmutableList<CommentStatement> headerCommentStatements;

  private final ImmutableList<AnnotationNode> annotations;

  private final ImmutableList<TypeNode> throwsExceptions;

  private final ImmutableList<VariableExpr> arguments;

  private final boolean isStatic;

  private final boolean isFinal;

  private final boolean isAbstract;

  private final boolean isConstructor;

  private final ImmutableList<Statement> body;

  private final ImmutableList<IdentifierNode> templateIdentifiers;

  private final ImmutableList<IdentifierNode> returnTemplateIdentifiers;

  private final ImmutableList<String> templateNames;

  private final ImmutableList<String> returnTemplateNames;

  @Nullable
  private final ReturnExpr returnExpr;

  private final boolean isOverride;

  @Nullable
  private final String name;

  private AutoValue_MethodDefinition(
      ScopeNode scope,
      TypeNode returnType,
      IdentifierNode methodIdentifier,
      ImmutableList<CommentStatement> headerCommentStatements,
      ImmutableList<AnnotationNode> annotations,
      ImmutableList<TypeNode> throwsExceptions,
      ImmutableList<VariableExpr> arguments,
      boolean isStatic,
      boolean isFinal,
      boolean isAbstract,
      boolean isConstructor,
      ImmutableList<Statement> body,
      ImmutableList<IdentifierNode> templateIdentifiers,
      ImmutableList<IdentifierNode> returnTemplateIdentifiers,
      ImmutableList<String> templateNames,
      ImmutableList<String> returnTemplateNames,
      @Nullable ReturnExpr returnExpr,
      boolean isOverride,
      @Nullable String name) {
    this.scope = scope;
    this.returnType = returnType;
    this.methodIdentifier = methodIdentifier;
    this.headerCommentStatements = headerCommentStatements;
    this.annotations = annotations;
    this.throwsExceptions = throwsExceptions;
    this.arguments = arguments;
    this.isStatic = isStatic;
    this.isFinal = isFinal;
    this.isAbstract = isAbstract;
    this.isConstructor = isConstructor;
    this.body = body;
    this.templateIdentifiers = templateIdentifiers;
    this.returnTemplateIdentifiers = returnTemplateIdentifiers;
    this.templateNames = templateNames;
    this.returnTemplateNames = returnTemplateNames;
    this.returnExpr = returnExpr;
    this.isOverride = isOverride;
    this.name = name;
  }

  @Override
  public ScopeNode scope() {
    return scope;
  }

  @Override
  public TypeNode returnType() {
    return returnType;
  }

  @Override
  public IdentifierNode methodIdentifier() {
    return methodIdentifier;
  }

  @Override
  public ImmutableList<CommentStatement> headerCommentStatements() {
    return headerCommentStatements;
  }

  @Override
  public ImmutableList<AnnotationNode> annotations() {
    return annotations;
  }

  @Override
  public ImmutableList<TypeNode> throwsExceptions() {
    return throwsExceptions;
  }

  @Override
  public ImmutableList<VariableExpr> arguments() {
    return arguments;
  }

  @Override
  public boolean isStatic() {
    return isStatic;
  }

  @Override
  public boolean isFinal() {
    return isFinal;
  }

  @Override
  public boolean isAbstract() {
    return isAbstract;
  }

  @Override
  public boolean isConstructor() {
    return isConstructor;
  }

  @Override
  public ImmutableList<Statement> body() {
    return body;
  }

  @Override
  public ImmutableList<IdentifierNode> templateIdentifiers() {
    return templateIdentifiers;
  }

  @Override
  public ImmutableList<IdentifierNode> returnTemplateIdentifiers() {
    return returnTemplateIdentifiers;
  }

  @Override
  ImmutableList<String> templateNames() {
    return templateNames;
  }

  @Override
  ImmutableList<String> returnTemplateNames() {
    return returnTemplateNames;
  }

  @Nullable
  @Override
  public ReturnExpr returnExpr() {
    return returnExpr;
  }

  @Override
  boolean isOverride() {
    return isOverride;
  }

  @Nullable
  @Override
  String name() {
    return name;
  }

  @Override
  public String toString() {
    return "MethodDefinition{"
        + "scope=" + scope + ", "
        + "returnType=" + returnType + ", "
        + "methodIdentifier=" + methodIdentifier + ", "
        + "headerCommentStatements=" + headerCommentStatements + ", "
        + "annotations=" + annotations + ", "
        + "throwsExceptions=" + throwsExceptions + ", "
        + "arguments=" + arguments + ", "
        + "isStatic=" + isStatic + ", "
        + "isFinal=" + isFinal + ", "
        + "isAbstract=" + isAbstract + ", "
        + "isConstructor=" + isConstructor + ", "
        + "body=" + body + ", "
        + "templateIdentifiers=" + templateIdentifiers + ", "
        + "returnTemplateIdentifiers=" + returnTemplateIdentifiers + ", "
        + "templateNames=" + templateNames + ", "
        + "returnTemplateNames=" + returnTemplateNames + ", "
        + "returnExpr=" + returnExpr + ", "
        + "isOverride=" + isOverride + ", "
        + "name=" + name
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MethodDefinition) {
      MethodDefinition that = (MethodDefinition) o;
      return this.scope.equals(that.scope())
          && this.returnType.equals(that.returnType())
          && this.methodIdentifier.equals(that.methodIdentifier())
          && this.headerCommentStatements.equals(that.headerCommentStatements())
          && this.annotations.equals(that.annotations())
          && this.throwsExceptions.equals(that.throwsExceptions())
          && this.arguments.equals(that.arguments())
          && this.isStatic == that.isStatic()
          && this.isFinal == that.isFinal()
          && this.isAbstract == that.isAbstract()
          && this.isConstructor == that.isConstructor()
          && this.body.equals(that.body())
          && this.templateIdentifiers.equals(that.templateIdentifiers())
          && this.returnTemplateIdentifiers.equals(that.returnTemplateIdentifiers())
          && this.templateNames.equals(that.templateNames())
          && this.returnTemplateNames.equals(that.returnTemplateNames())
          && (this.returnExpr == null ? that.returnExpr() == null : this.returnExpr.equals(that.returnExpr()))
          && this.isOverride == that.isOverride()
          && (this.name == null ? that.name() == null : this.name.equals(that.name()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= returnType.hashCode();
    h$ *= 1000003;
    h$ ^= methodIdentifier.hashCode();
    h$ *= 1000003;
    h$ ^= headerCommentStatements.hashCode();
    h$ *= 1000003;
    h$ ^= annotations.hashCode();
    h$ *= 1000003;
    h$ ^= throwsExceptions.hashCode();
    h$ *= 1000003;
    h$ ^= arguments.hashCode();
    h$ *= 1000003;
    h$ ^= isStatic ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isFinal ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isAbstract ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isConstructor ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= body.hashCode();
    h$ *= 1000003;
    h$ ^= templateIdentifiers.hashCode();
    h$ *= 1000003;
    h$ ^= returnTemplateIdentifiers.hashCode();
    h$ *= 1000003;
    h$ ^= templateNames.hashCode();
    h$ *= 1000003;
    h$ ^= returnTemplateNames.hashCode();
    h$ *= 1000003;
    h$ ^= (returnExpr == null) ? 0 : returnExpr.hashCode();
    h$ *= 1000003;
    h$ ^= isOverride ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (name == null) ? 0 : name.hashCode();
    return h$;
  }

  @Override
  public MethodDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MethodDefinition.Builder {
    private ScopeNode scope;
    private TypeNode returnType;
    private IdentifierNode methodIdentifier;
    private ImmutableList<CommentStatement> headerCommentStatements;
    private ImmutableList<AnnotationNode> annotations;
    private ImmutableList<TypeNode> throwsExceptions;
    private ImmutableList<VariableExpr> arguments;
    private boolean isStatic;
    private boolean isFinal;
    private boolean isAbstract;
    private boolean isConstructor;
    private ImmutableList<Statement> body;
    private ImmutableList<IdentifierNode> templateIdentifiers;
    private ImmutableList<IdentifierNode> returnTemplateIdentifiers;
    private ImmutableList<String> templateNames;
    private ImmutableList<String> returnTemplateNames;
    private ReturnExpr returnExpr;
    private boolean isOverride;
    private String name;
    private byte set$0;
    Builder() {
    }
    private Builder(MethodDefinition source) {
      this.scope = source.scope();
      this.returnType = source.returnType();
      this.methodIdentifier = source.methodIdentifier();
      this.headerCommentStatements = source.headerCommentStatements();
      this.annotations = source.annotations();
      this.throwsExceptions = source.throwsExceptions();
      this.arguments = source.arguments();
      this.isStatic = source.isStatic();
      this.isFinal = source.isFinal();
      this.isAbstract = source.isAbstract();
      this.isConstructor = source.isConstructor();
      this.body = source.body();
      this.templateIdentifiers = source.templateIdentifiers();
      this.returnTemplateIdentifiers = source.returnTemplateIdentifiers();
      this.templateNames = source.templateNames();
      this.returnTemplateNames = source.returnTemplateNames();
      this.returnExpr = source.returnExpr();
      this.isOverride = source.isOverride();
      this.name = source.name();
      set$0 = (byte) 0x1f;
    }
    @Override
    public MethodDefinition.Builder setScope(ScopeNode scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    ScopeNode scope() {
      if (this.scope == null) {
        throw new IllegalStateException("Property \"scope\" has not been set");
      }
      return scope;
    }
    @Override
    public MethodDefinition.Builder setReturnType(TypeNode returnType) {
      if (returnType == null) {
        throw new NullPointerException("Null returnType");
      }
      this.returnType = returnType;
      return this;
    }
    @Override
    TypeNode returnType() {
      if (this.returnType == null) {
        throw new IllegalStateException("Property \"returnType\" has not been set");
      }
      return returnType;
    }
    @Override
    MethodDefinition.Builder setMethodIdentifier(IdentifierNode methodIdentifier) {
      if (methodIdentifier == null) {
        throw new NullPointerException("Null methodIdentifier");
      }
      this.methodIdentifier = methodIdentifier;
      return this;
    }
    @Override
    public MethodDefinition.Builder setHeaderCommentStatements(List<CommentStatement> headerCommentStatements) {
      this.headerCommentStatements = ImmutableList.copyOf(headerCommentStatements);
      return this;
    }
    @Override
    ImmutableList<CommentStatement> headerCommentStatements() {
      if (this.headerCommentStatements == null) {
        throw new IllegalStateException("Property \"headerCommentStatements\" has not been set");
      }
      return headerCommentStatements;
    }
    @Override
    public MethodDefinition.Builder setAnnotations(List<AnnotationNode> annotations) {
      this.annotations = ImmutableList.copyOf(annotations);
      return this;
    }
    @Override
    ImmutableList<AnnotationNode> annotations() {
      if (this.annotations == null) {
        throw new IllegalStateException("Property \"annotations\" has not been set");
      }
      return annotations;
    }
    @Override
    public MethodDefinition.Builder setThrowsExceptions(List<TypeNode> throwsExceptions) {
      this.throwsExceptions = ImmutableList.copyOf(throwsExceptions);
      return this;
    }
    @Override
    ImmutableList<TypeNode> throwsExceptions() {
      if (this.throwsExceptions == null) {
        throw new IllegalStateException("Property \"throwsExceptions\" has not been set");
      }
      return throwsExceptions;
    }
    @Override
    public MethodDefinition.Builder setArguments(List<VariableExpr> arguments) {
      this.arguments = ImmutableList.copyOf(arguments);
      return this;
    }
    @Override
    ImmutableList<VariableExpr> arguments() {
      if (this.arguments == null) {
        throw new IllegalStateException("Property \"arguments\" has not been set");
      }
      return arguments;
    }
    @Override
    public MethodDefinition.Builder setIsStatic(boolean isStatic) {
      this.isStatic = isStatic;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    boolean isStatic() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"isStatic\" has not been set");
      }
      return isStatic;
    }
    @Override
    public MethodDefinition.Builder setIsFinal(boolean isFinal) {
      this.isFinal = isFinal;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    boolean isFinal() {
      if ((set$0 & 2) == 0) {
        throw new IllegalStateException("Property \"isFinal\" has not been set");
      }
      return isFinal;
    }
    @Override
    public MethodDefinition.Builder setIsAbstract(boolean isAbstract) {
      this.isAbstract = isAbstract;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    boolean isAbstract() {
      if ((set$0 & 4) == 0) {
        throw new IllegalStateException("Property \"isAbstract\" has not been set");
      }
      return isAbstract;
    }
    @Override
    public MethodDefinition.Builder setIsConstructor(boolean isConstructor) {
      this.isConstructor = isConstructor;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    boolean isConstructor() {
      if ((set$0 & 8) == 0) {
        throw new IllegalStateException("Property \"isConstructor\" has not been set");
      }
      return isConstructor;
    }
    @Override
    public MethodDefinition.Builder setBody(List<Statement> body) {
      this.body = ImmutableList.copyOf(body);
      return this;
    }
    @Override
    ImmutableList<Statement> body() {
      if (this.body == null) {
        throw new IllegalStateException("Property \"body\" has not been set");
      }
      return body;
    }
    @Override
    MethodDefinition.Builder setTemplateIdentifiers(List<IdentifierNode> templateIdentifiers) {
      this.templateIdentifiers = ImmutableList.copyOf(templateIdentifiers);
      return this;
    }
    @Override
    MethodDefinition.Builder setReturnTemplateIdentifiers(List<IdentifierNode> returnTemplateIdentifiers) {
      this.returnTemplateIdentifiers = ImmutableList.copyOf(returnTemplateIdentifiers);
      return this;
    }
    @Override
    public MethodDefinition.Builder setTemplateNames(List<String> templateNames) {
      this.templateNames = ImmutableList.copyOf(templateNames);
      return this;
    }
    @Override
    ImmutableList<String> templateNames() {
      if (this.templateNames == null) {
        throw new IllegalStateException("Property \"templateNames\" has not been set");
      }
      return templateNames;
    }
    @Override
    public MethodDefinition.Builder setReturnTemplateNames(List<String> returnTemplateNames) {
      this.returnTemplateNames = ImmutableList.copyOf(returnTemplateNames);
      return this;
    }
    @Override
    ImmutableList<String> returnTemplateNames() {
      if (this.returnTemplateNames == null) {
        throw new IllegalStateException("Property \"returnTemplateNames\" has not been set");
      }
      return returnTemplateNames;
    }
    @Override
    public MethodDefinition.Builder setReturnExpr(ReturnExpr returnExpr) {
      this.returnExpr = returnExpr;
      return this;
    }
    @Override
    public MethodDefinition.Builder setIsOverride(boolean isOverride) {
      this.isOverride = isOverride;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    boolean isOverride() {
      if ((set$0 & 0x10) == 0) {
        throw new IllegalStateException("Property \"isOverride\" has not been set");
      }
      return isOverride;
    }
    @Override
    public MethodDefinition.Builder setName(String name) {
      this.name = name;
      return this;
    }
    @Override
    @Nullable String name() {
      return name;
    }
    @Override
    MethodDefinition autoBuild() {
      if (set$0 != 0x1f
          || this.scope == null
          || this.returnType == null
          || this.methodIdentifier == null
          || this.headerCommentStatements == null
          || this.annotations == null
          || this.throwsExceptions == null
          || this.arguments == null
          || this.body == null
          || this.templateIdentifiers == null
          || this.returnTemplateIdentifiers == null
          || this.templateNames == null
          || this.returnTemplateNames == null) {
        StringBuilder missing = new StringBuilder();
        if (this.scope == null) {
          missing.append(" scope");
        }
        if (this.returnType == null) {
          missing.append(" returnType");
        }
        if (this.methodIdentifier == null) {
          missing.append(" methodIdentifier");
        }
        if (this.headerCommentStatements == null) {
          missing.append(" headerCommentStatements");
        }
        if (this.annotations == null) {
          missing.append(" annotations");
        }
        if (this.throwsExceptions == null) {
          missing.append(" throwsExceptions");
        }
        if (this.arguments == null) {
          missing.append(" arguments");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isStatic");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" isFinal");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" isAbstract");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" isConstructor");
        }
        if (this.body == null) {
          missing.append(" body");
        }
        if (this.templateIdentifiers == null) {
          missing.append(" templateIdentifiers");
        }
        if (this.returnTemplateIdentifiers == null) {
          missing.append(" returnTemplateIdentifiers");
        }
        if (this.templateNames == null) {
          missing.append(" templateNames");
        }
        if (this.returnTemplateNames == null) {
          missing.append(" returnTemplateNames");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" isOverride");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MethodDefinition(
          this.scope,
          this.returnType,
          this.methodIdentifier,
          this.headerCommentStatements,
          this.annotations,
          this.throwsExceptions,
          this.arguments,
          this.isStatic,
          this.isFinal,
          this.isAbstract,
          this.isConstructor,
          this.body,
          this.templateIdentifiers,
          this.returnTemplateIdentifiers,
          this.templateNames,
          this.returnTemplateNames,
          this.returnExpr,
          this.isOverride,
          this.name);
    }
  }

}
