package com.google.api.generator.engine.ast;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MethodInvocationExpr extends MethodInvocationExpr {

  private final IdentifierNode methodIdentifier;

  private final TypeNode returnType;

  @Nullable
  private final Expr exprReferenceExpr;

  @Nullable
  private final TypeNode staticReferenceType;

  private final List<Expr> arguments;

  private final List<Reference> generics;

  private final String methodName;

  private AutoValue_MethodInvocationExpr(
      IdentifierNode methodIdentifier,
      TypeNode returnType,
      @Nullable Expr exprReferenceExpr,
      @Nullable TypeNode staticReferenceType,
      List<Expr> arguments,
      List<Reference> generics,
      String methodName) {
    this.methodIdentifier = methodIdentifier;
    this.returnType = returnType;
    this.exprReferenceExpr = exprReferenceExpr;
    this.staticReferenceType = staticReferenceType;
    this.arguments = arguments;
    this.generics = generics;
    this.methodName = methodName;
  }

  @Override
  public IdentifierNode methodIdentifier() {
    return methodIdentifier;
  }

  @Override
  public TypeNode returnType() {
    return returnType;
  }

  @Nullable
  @Override
  public Expr exprReferenceExpr() {
    return exprReferenceExpr;
  }

  @Nullable
  @Override
  public TypeNode staticReferenceType() {
    return staticReferenceType;
  }

  @Override
  public List<Expr> arguments() {
    return arguments;
  }

  @Override
  public List<Reference> generics() {
    return generics;
  }

  @Override
  String methodName() {
    return methodName;
  }

  @Override
  public String toString() {
    return "MethodInvocationExpr{"
        + "methodIdentifier=" + methodIdentifier + ", "
        + "returnType=" + returnType + ", "
        + "exprReferenceExpr=" + exprReferenceExpr + ", "
        + "staticReferenceType=" + staticReferenceType + ", "
        + "arguments=" + arguments + ", "
        + "generics=" + generics + ", "
        + "methodName=" + methodName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MethodInvocationExpr) {
      MethodInvocationExpr that = (MethodInvocationExpr) o;
      return this.methodIdentifier.equals(that.methodIdentifier())
          && this.returnType.equals(that.returnType())
          && (this.exprReferenceExpr == null ? that.exprReferenceExpr() == null : this.exprReferenceExpr.equals(that.exprReferenceExpr()))
          && (this.staticReferenceType == null ? that.staticReferenceType() == null : this.staticReferenceType.equals(that.staticReferenceType()))
          && this.arguments.equals(that.arguments())
          && this.generics.equals(that.generics())
          && this.methodName.equals(that.methodName());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= methodIdentifier.hashCode();
    h$ *= 1000003;
    h$ ^= returnType.hashCode();
    h$ *= 1000003;
    h$ ^= (exprReferenceExpr == null) ? 0 : exprReferenceExpr.hashCode();
    h$ *= 1000003;
    h$ ^= (staticReferenceType == null) ? 0 : staticReferenceType.hashCode();
    h$ *= 1000003;
    h$ ^= arguments.hashCode();
    h$ *= 1000003;
    h$ ^= generics.hashCode();
    h$ *= 1000003;
    h$ ^= methodName.hashCode();
    return h$;
  }

  @Override
  public MethodInvocationExpr.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MethodInvocationExpr.Builder {
    private IdentifierNode methodIdentifier;
    private TypeNode returnType;
    private Expr exprReferenceExpr;
    private TypeNode staticReferenceType;
    private List<Expr> arguments;
    private List<Reference> generics;
    private String methodName;
    Builder() {
    }
    private Builder(MethodInvocationExpr source) {
      this.methodIdentifier = source.methodIdentifier();
      this.returnType = source.returnType();
      this.exprReferenceExpr = source.exprReferenceExpr();
      this.staticReferenceType = source.staticReferenceType();
      this.arguments = source.arguments();
      this.generics = source.generics();
      this.methodName = source.methodName();
    }
    @Override
    MethodInvocationExpr.Builder setMethodIdentifier(IdentifierNode methodIdentifier) {
      if (methodIdentifier == null) {
        throw new NullPointerException("Null methodIdentifier");
      }
      this.methodIdentifier = methodIdentifier;
      return this;
    }
    @Override
    public MethodInvocationExpr.Builder setReturnType(TypeNode returnType) {
      if (returnType == null) {
        throw new NullPointerException("Null returnType");
      }
      this.returnType = returnType;
      return this;
    }
    @Override
    public MethodInvocationExpr.Builder setExprReferenceExpr(Expr exprReferenceExpr) {
      this.exprReferenceExpr = exprReferenceExpr;
      return this;
    }
    @Override
    public MethodInvocationExpr.Builder setStaticReferenceType(TypeNode staticReferenceType) {
      this.staticReferenceType = staticReferenceType;
      return this;
    }
    @Override
    public MethodInvocationExpr.Builder setArguments(List<Expr> arguments) {
      if (arguments == null) {
        throw new NullPointerException("Null arguments");
      }
      this.arguments = arguments;
      return this;
    }
    @Override
    public MethodInvocationExpr.Builder setGenerics(List<Reference> generics) {
      if (generics == null) {
        throw new NullPointerException("Null generics");
      }
      this.generics = generics;
      return this;
    }
    @Override
    public MethodInvocationExpr.Builder setMethodName(String methodName) {
      if (methodName == null) {
        throw new NullPointerException("Null methodName");
      }
      this.methodName = methodName;
      return this;
    }
    @Override
    String methodName() {
      if (this.methodName == null) {
        throw new IllegalStateException("Property \"methodName\" has not been set");
      }
      return methodName;
    }
    @Override
    MethodInvocationExpr autoBuild() {
      if (this.methodIdentifier == null
          || this.returnType == null
          || this.arguments == null
          || this.generics == null
          || this.methodName == null) {
        StringBuilder missing = new StringBuilder();
        if (this.methodIdentifier == null) {
          missing.append(" methodIdentifier");
        }
        if (this.returnType == null) {
          missing.append(" returnType");
        }
        if (this.arguments == null) {
          missing.append(" arguments");
        }
        if (this.generics == null) {
          missing.append(" generics");
        }
        if (this.methodName == null) {
          missing.append(" methodName");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MethodInvocationExpr(
          this.methodIdentifier,
          this.returnType,
          this.exprReferenceExpr,
          this.staticReferenceType,
          this.arguments,
          this.generics,
          this.methodName);
    }
  }

}
