package com.google.api.generator.engine.ast;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PrimitiveValue extends PrimitiveValue {

  private final TypeNode type;

  private final String value;

  private AutoValue_PrimitiveValue(
      TypeNode type,
      String value) {
    this.type = type;
    this.value = value;
  }

  @Override
  public TypeNode type() {
    return type;
  }

  @Override
  public String value() {
    return value;
  }

  @Override
  public String toString() {
    return "PrimitiveValue{"
        + "type=" + type + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PrimitiveValue) {
      PrimitiveValue that = (PrimitiveValue) o;
      return this.type.equals(that.type())
          && this.value.equals(that.value());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    return h$;
  }

  static final class Builder extends PrimitiveValue.Builder {
    private TypeNode type;
    private String value;
    Builder() {
    }
    @Override
    public PrimitiveValue.Builder setType(TypeNode type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public PrimitiveValue.Builder setValue(String value) {
      if (value == null) {
        throw new NullPointerException("Null value");
      }
      this.value = value;
      return this;
    }
    @Override
    PrimitiveValue autoBuild() {
      if (this.type == null
          || this.value == null) {
        StringBuilder missing = new StringBuilder();
        if (this.type == null) {
          missing.append(" type");
        }
        if (this.value == null) {
          missing.append(" value");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PrimitiveValue(
          this.type,
          this.value);
    }
  }

}
