package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TryCatchStatement extends TryCatchStatement {

  private final ImmutableList<Statement> tryBody;

  private final List<VariableExpr> catchVariableExprs;

  private final List<List<Statement>> catchBlocks;

  @Nullable
  private final AssignmentExpr tryResourceExpr;

  private final boolean isSampleCode;

  private AutoValue_TryCatchStatement(
      ImmutableList<Statement> tryBody,
      List<VariableExpr> catchVariableExprs,
      List<List<Statement>> catchBlocks,
      @Nullable AssignmentExpr tryResourceExpr,
      boolean isSampleCode) {
    this.tryBody = tryBody;
    this.catchVariableExprs = catchVariableExprs;
    this.catchBlocks = catchBlocks;
    this.tryResourceExpr = tryResourceExpr;
    this.isSampleCode = isSampleCode;
  }

  @Override
  public ImmutableList<Statement> tryBody() {
    return tryBody;
  }

  @Override
  public List<VariableExpr> catchVariableExprs() {
    return catchVariableExprs;
  }

  @Override
  public List<List<Statement>> catchBlocks() {
    return catchBlocks;
  }

  @Nullable
  @Override
  public AssignmentExpr tryResourceExpr() {
    return tryResourceExpr;
  }

  @Override
  public boolean isSampleCode() {
    return isSampleCode;
  }

  @Override
  public String toString() {
    return "TryCatchStatement{"
        + "tryBody=" + tryBody + ", "
        + "catchVariableExprs=" + catchVariableExprs + ", "
        + "catchBlocks=" + catchBlocks + ", "
        + "tryResourceExpr=" + tryResourceExpr + ", "
        + "isSampleCode=" + isSampleCode
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TryCatchStatement) {
      TryCatchStatement that = (TryCatchStatement) o;
      return this.tryBody.equals(that.tryBody())
          && this.catchVariableExprs.equals(that.catchVariableExprs())
          && this.catchBlocks.equals(that.catchBlocks())
          && (this.tryResourceExpr == null ? that.tryResourceExpr() == null : this.tryResourceExpr.equals(that.tryResourceExpr()))
          && this.isSampleCode == that.isSampleCode();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= tryBody.hashCode();
    h$ *= 1000003;
    h$ ^= catchVariableExprs.hashCode();
    h$ *= 1000003;
    h$ ^= catchBlocks.hashCode();
    h$ *= 1000003;
    h$ ^= (tryResourceExpr == null) ? 0 : tryResourceExpr.hashCode();
    h$ *= 1000003;
    h$ ^= isSampleCode ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends TryCatchStatement.Builder {
    private ImmutableList<Statement> tryBody;
    private List<VariableExpr> catchVariableExprs;
    private List<List<Statement>> catchBlocks;
    private AssignmentExpr tryResourceExpr;
    private boolean isSampleCode;
    private byte set$0;
    Builder() {
    }
    @Override
    public TryCatchStatement.Builder setTryBody(List<Statement> tryBody) {
      this.tryBody = ImmutableList.copyOf(tryBody);
      return this;
    }
    @Override
    ImmutableList<Statement> tryBody() {
      if (this.tryBody == null) {
        throw new IllegalStateException("Property \"tryBody\" has not been set");
      }
      return tryBody;
    }
    @Override
    TryCatchStatement.Builder setCatchVariableExprs(List<VariableExpr> catchVariableExprs) {
      if (catchVariableExprs == null) {
        throw new NullPointerException("Null catchVariableExprs");
      }
      this.catchVariableExprs = catchVariableExprs;
      return this;
    }
    @Override
    List<VariableExpr> catchVariableExprs() {
      if (this.catchVariableExprs == null) {
        throw new IllegalStateException("Property \"catchVariableExprs\" has not been set");
      }
      return catchVariableExprs;
    }
    @Override
    TryCatchStatement.Builder setCatchBlocks(List<List<Statement>> catchBlocks) {
      if (catchBlocks == null) {
        throw new NullPointerException("Null catchBlocks");
      }
      this.catchBlocks = catchBlocks;
      return this;
    }
    @Override
    List<List<Statement>> catchBlocks() {
      if (this.catchBlocks == null) {
        throw new IllegalStateException("Property \"catchBlocks\" has not been set");
      }
      return catchBlocks;
    }
    @Override
    public TryCatchStatement.Builder setTryResourceExpr(AssignmentExpr tryResourceExpr) {
      this.tryResourceExpr = tryResourceExpr;
      return this;
    }
    @Override
    public TryCatchStatement.Builder setIsSampleCode(boolean isSampleCode) {
      this.isSampleCode = isSampleCode;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    boolean isSampleCode() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"isSampleCode\" has not been set");
      }
      return isSampleCode;
    }
    @Override
    TryCatchStatement autoBuild() {
      if (set$0 != 1
          || this.tryBody == null
          || this.catchVariableExprs == null
          || this.catchBlocks == null) {
        StringBuilder missing = new StringBuilder();
        if (this.tryBody == null) {
          missing.append(" tryBody");
        }
        if (this.catchVariableExprs == null) {
          missing.append(" catchVariableExprs");
        }
        if (this.catchBlocks == null) {
          missing.append(" catchBlocks");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isSampleCode");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TryCatchStatement(
          this.tryBody,
          this.catchVariableExprs,
          this.catchBlocks,
          this.tryResourceExpr,
          this.isSampleCode);
    }
  }

}
