package com.google.api.generator.engine.ast;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TypeNode extends TypeNode {

  private final TypeNode.TypeKind typeKind;

  private final boolean isArray;

  @Nullable
  private final Reference reference;

  private AutoValue_TypeNode(
      TypeNode.TypeKind typeKind,
      boolean isArray,
      @Nullable Reference reference) {
    this.typeKind = typeKind;
    this.isArray = isArray;
    this.reference = reference;
  }

  @Override
  public TypeNode.TypeKind typeKind() {
    return typeKind;
  }

  @Override
  public boolean isArray() {
    return isArray;
  }

  @Nullable
  @Override
  public Reference reference() {
    return reference;
  }

  @Override
  public String toString() {
    return "TypeNode{"
        + "typeKind=" + typeKind + ", "
        + "isArray=" + isArray + ", "
        + "reference=" + reference
        + "}";
  }

  static final class Builder extends TypeNode.Builder {
    private TypeNode.TypeKind typeKind;
    private boolean isArray;
    private Reference reference;
    private byte set$0;
    Builder() {
    }
    @Override
    public TypeNode.Builder setTypeKind(TypeNode.TypeKind typeKind) {
      if (typeKind == null) {
        throw new NullPointerException("Null typeKind");
      }
      this.typeKind = typeKind;
      return this;
    }
    @Override
    public TypeNode.Builder setIsArray(boolean isArray) {
      this.isArray = isArray;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public TypeNode.Builder setReference(Reference reference) {
      this.reference = reference;
      return this;
    }
    @Override
    @Nullable Reference reference() {
      return reference;
    }
    @Override
    TypeNode autoBuild() {
      if (set$0 != 1
          || this.typeKind == null) {
        StringBuilder missing = new StringBuilder();
        if (this.typeKind == null) {
          missing.append(" typeKind");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isArray");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TypeNode(
          this.typeKind,
          this.isArray,
          this.reference);
    }
  }

}
