package com.google.api.generator.engine.ast;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_UnaryOperationExpr extends UnaryOperationExpr {

  private final Expr expr;

  private final OperatorKind operatorKind;

  private final TypeNode type;

  private AutoValue_UnaryOperationExpr(
      Expr expr,
      OperatorKind operatorKind,
      TypeNode type) {
    this.expr = expr;
    this.operatorKind = operatorKind;
    this.type = type;
  }

  @Override
  public Expr expr() {
    return expr;
  }

  @Override
  public OperatorKind operatorKind() {
    return operatorKind;
  }

  @Override
  public TypeNode type() {
    return type;
  }

  @Override
  public String toString() {
    return "UnaryOperationExpr{"
        + "expr=" + expr + ", "
        + "operatorKind=" + operatorKind + ", "
        + "type=" + type
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof UnaryOperationExpr) {
      UnaryOperationExpr that = (UnaryOperationExpr) o;
      return this.expr.equals(that.expr())
          && this.operatorKind.equals(that.operatorKind())
          && this.type.equals(that.type());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= expr.hashCode();
    h$ *= 1000003;
    h$ ^= operatorKind.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    return h$;
  }

  static final class Builder extends UnaryOperationExpr.Builder {
    private Expr expr;
    private OperatorKind operatorKind;
    private TypeNode type;
    Builder() {
    }
    @Override
    UnaryOperationExpr.Builder setExpr(Expr expr) {
      if (expr == null) {
        throw new NullPointerException("Null expr");
      }
      this.expr = expr;
      return this;
    }
    @Override
    UnaryOperationExpr.Builder setOperatorKind(OperatorKind operatorKind) {
      if (operatorKind == null) {
        throw new NullPointerException("Null operatorKind");
      }
      this.operatorKind = operatorKind;
      return this;
    }
    @Override
    UnaryOperationExpr.Builder setType(TypeNode type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    UnaryOperationExpr autoBuild() {
      if (this.expr == null
          || this.operatorKind == null
          || this.type == null) {
        StringBuilder missing = new StringBuilder();
        if (this.expr == null) {
          missing.append(" expr");
        }
        if (this.operatorKind == null) {
          missing.append(" operatorKind");
        }
        if (this.type == null) {
          missing.append(" type");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_UnaryOperationExpr(
          this.expr,
          this.operatorKind,
          this.type);
    }
  }

}
