package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_VariableExpr extends VariableExpr {

  private final Variable variable;

  @Nullable
  private final Expr exprReferenceExpr;

  @Nullable
  private final TypeNode staticReferenceType;

  private final boolean isDecl;

  private final ScopeNode scope;

  private final boolean isStatic;

  private final boolean isFinal;

  private final boolean isVolatile;

  private final ImmutableList<AnnotationNode> annotations;

  private final ImmutableList<AstNode> templateNodes;

  private final ImmutableList<Object> templateObjects;

  private AutoValue_VariableExpr(
      Variable variable,
      @Nullable Expr exprReferenceExpr,
      @Nullable TypeNode staticReferenceType,
      boolean isDecl,
      ScopeNode scope,
      boolean isStatic,
      boolean isFinal,
      boolean isVolatile,
      ImmutableList<AnnotationNode> annotations,
      ImmutableList<AstNode> templateNodes,
      ImmutableList<Object> templateObjects) {
    this.variable = variable;
    this.exprReferenceExpr = exprReferenceExpr;
    this.staticReferenceType = staticReferenceType;
    this.isDecl = isDecl;
    this.scope = scope;
    this.isStatic = isStatic;
    this.isFinal = isFinal;
    this.isVolatile = isVolatile;
    this.annotations = annotations;
    this.templateNodes = templateNodes;
    this.templateObjects = templateObjects;
  }

  @Override
  public Variable variable() {
    return variable;
  }

  @Nullable
  @Override
  public Expr exprReferenceExpr() {
    return exprReferenceExpr;
  }

  @Nullable
  @Override
  public TypeNode staticReferenceType() {
    return staticReferenceType;
  }

  @Override
  public boolean isDecl() {
    return isDecl;
  }

  @Override
  public ScopeNode scope() {
    return scope;
  }

  @Override
  public boolean isStatic() {
    return isStatic;
  }

  @Override
  public boolean isFinal() {
    return isFinal;
  }

  @Override
  public boolean isVolatile() {
    return isVolatile;
  }

  @Override
  public ImmutableList<AnnotationNode> annotations() {
    return annotations;
  }

  @Override
  public ImmutableList<AstNode> templateNodes() {
    return templateNodes;
  }

  @Override
  ImmutableList<Object> templateObjects() {
    return templateObjects;
  }

  @Override
  public String toString() {
    return "VariableExpr{"
        + "variable=" + variable + ", "
        + "exprReferenceExpr=" + exprReferenceExpr + ", "
        + "staticReferenceType=" + staticReferenceType + ", "
        + "isDecl=" + isDecl + ", "
        + "scope=" + scope + ", "
        + "isStatic=" + isStatic + ", "
        + "isFinal=" + isFinal + ", "
        + "isVolatile=" + isVolatile + ", "
        + "annotations=" + annotations + ", "
        + "templateNodes=" + templateNodes + ", "
        + "templateObjects=" + templateObjects
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof VariableExpr) {
      VariableExpr that = (VariableExpr) o;
      return this.variable.equals(that.variable())
          && (this.exprReferenceExpr == null ? that.exprReferenceExpr() == null : this.exprReferenceExpr.equals(that.exprReferenceExpr()))
          && (this.staticReferenceType == null ? that.staticReferenceType() == null : this.staticReferenceType.equals(that.staticReferenceType()))
          && this.isDecl == that.isDecl()
          && this.scope.equals(that.scope())
          && this.isStatic == that.isStatic()
          && this.isFinal == that.isFinal()
          && this.isVolatile == that.isVolatile()
          && this.annotations.equals(that.annotations())
          && this.templateNodes.equals(that.templateNodes())
          && this.templateObjects.equals(that.templateObjects());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= variable.hashCode();
    h$ *= 1000003;
    h$ ^= (exprReferenceExpr == null) ? 0 : exprReferenceExpr.hashCode();
    h$ *= 1000003;
    h$ ^= (staticReferenceType == null) ? 0 : staticReferenceType.hashCode();
    h$ *= 1000003;
    h$ ^= isDecl ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= isStatic ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isFinal ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isVolatile ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= annotations.hashCode();
    h$ *= 1000003;
    h$ ^= templateNodes.hashCode();
    h$ *= 1000003;
    h$ ^= templateObjects.hashCode();
    return h$;
  }

  @Override
  public VariableExpr.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends VariableExpr.Builder {
    private Variable variable;
    private Expr exprReferenceExpr;
    private TypeNode staticReferenceType;
    private boolean isDecl;
    private ScopeNode scope;
    private boolean isStatic;
    private boolean isFinal;
    private boolean isVolatile;
    private ImmutableList<AnnotationNode> annotations;
    private ImmutableList<AstNode> templateNodes;
    private ImmutableList<Object> templateObjects;
    private byte set$0;
    Builder() {
    }
    private Builder(VariableExpr source) {
      this.variable = source.variable();
      this.exprReferenceExpr = source.exprReferenceExpr();
      this.staticReferenceType = source.staticReferenceType();
      this.isDecl = source.isDecl();
      this.scope = source.scope();
      this.isStatic = source.isStatic();
      this.isFinal = source.isFinal();
      this.isVolatile = source.isVolatile();
      this.annotations = source.annotations();
      this.templateNodes = source.templateNodes();
      this.templateObjects = source.templateObjects();
      set$0 = (byte) 0xf;
    }
    @Override
    public VariableExpr.Builder setVariable(Variable variable) {
      if (variable == null) {
        throw new NullPointerException("Null variable");
      }
      this.variable = variable;
      return this;
    }
    @Override
    Variable variable() {
      if (this.variable == null) {
        throw new IllegalStateException("Property \"variable\" has not been set");
      }
      return variable;
    }
    @Override
    public VariableExpr.Builder setExprReferenceExpr(Expr exprReferenceExpr) {
      this.exprReferenceExpr = exprReferenceExpr;
      return this;
    }
    @Override
    public VariableExpr.Builder setStaticReferenceType(TypeNode staticReferenceType) {
      this.staticReferenceType = staticReferenceType;
      return this;
    }
    @Override
    public VariableExpr.Builder setIsDecl(boolean isDecl) {
      this.isDecl = isDecl;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public VariableExpr.Builder setScope(ScopeNode scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    public VariableExpr.Builder setIsStatic(boolean isStatic) {
      this.isStatic = isStatic;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public VariableExpr.Builder setIsFinal(boolean isFinal) {
      this.isFinal = isFinal;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public VariableExpr.Builder setIsVolatile(boolean isVolatile) {
      this.isVolatile = isVolatile;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public VariableExpr.Builder setAnnotations(List<AnnotationNode> annotations) {
      this.annotations = ImmutableList.copyOf(annotations);
      return this;
    }
    @Override
    ImmutableList<AnnotationNode> annotations() {
      if (this.annotations == null) {
        throw new IllegalStateException("Property \"annotations\" has not been set");
      }
      return annotations;
    }
    @Override
    VariableExpr.Builder setTemplateNodes(List<AstNode> templateNodes) {
      this.templateNodes = ImmutableList.copyOf(templateNodes);
      return this;
    }
    @Override
    public VariableExpr.Builder setTemplateObjects(List<Object> templateObjects) {
      this.templateObjects = ImmutableList.copyOf(templateObjects);
      return this;
    }
    @Override
    ImmutableList<Object> templateObjects() {
      if (this.templateObjects == null) {
        throw new IllegalStateException("Property \"templateObjects\" has not been set");
      }
      return templateObjects;
    }
    @Override
    VariableExpr autoBuild() {
      if (set$0 != 0xf
          || this.variable == null
          || this.scope == null
          || this.annotations == null
          || this.templateNodes == null
          || this.templateObjects == null) {
        StringBuilder missing = new StringBuilder();
        if (this.variable == null) {
          missing.append(" variable");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isDecl");
        }
        if (this.scope == null) {
          missing.append(" scope");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" isStatic");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" isFinal");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" isVolatile");
        }
        if (this.annotations == null) {
          missing.append(" annotations");
        }
        if (this.templateNodes == null) {
          missing.append(" templateNodes");
        }
        if (this.templateObjects == null) {
          missing.append(" templateObjects");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_VariableExpr(
          this.variable,
          this.exprReferenceExpr,
          this.staticReferenceType,
          this.isDecl,
          this.scope,
          this.isStatic,
          this.isFinal,
          this.isVolatile,
          this.annotations,
          this.templateNodes,
          this.templateObjects);
    }
  }

}
