package com.google.api.generator.engine.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_WhileStatement extends WhileStatement {

  private final Expr conditionExpr;

  private final ImmutableList<Statement> body;

  private AutoValue_WhileStatement(
      Expr conditionExpr,
      ImmutableList<Statement> body) {
    this.conditionExpr = conditionExpr;
    this.body = body;
  }

  @Override
  public Expr conditionExpr() {
    return conditionExpr;
  }

  @Override
  public ImmutableList<Statement> body() {
    return body;
  }

  @Override
  public String toString() {
    return "WhileStatement{"
        + "conditionExpr=" + conditionExpr + ", "
        + "body=" + body
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof WhileStatement) {
      WhileStatement that = (WhileStatement) o;
      return this.conditionExpr.equals(that.conditionExpr())
          && this.body.equals(that.body());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= conditionExpr.hashCode();
    h$ *= 1000003;
    h$ ^= body.hashCode();
    return h$;
  }

  static final class Builder extends WhileStatement.Builder {
    private Expr conditionExpr;
    private ImmutableList<Statement> body;
    Builder() {
    }
    @Override
    public WhileStatement.Builder setConditionExpr(Expr conditionExpr) {
      if (conditionExpr == null) {
        throw new NullPointerException("Null conditionExpr");
      }
      this.conditionExpr = conditionExpr;
      return this;
    }
    @Override
    public WhileStatement.Builder setBody(List<Statement> body) {
      this.body = ImmutableList.copyOf(body);
      return this;
    }
    @Override
    ImmutableList<Statement> body() {
      if (this.body == null) {
        throw new IllegalStateException("Property \"body\" has not been set");
      }
      return body;
    }
    @Override
    WhileStatement autoBuild() {
      if (this.conditionExpr == null
          || this.body == null) {
        StringBuilder missing = new StringBuilder();
        if (this.conditionExpr == null) {
          missing.append(" conditionExpr");
        }
        if (this.body == null) {
          missing.append(" body");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_WhileStatement(
          this.conditionExpr,
          this.body);
    }
  }

}
