// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.api.generator.engine.ast;

import com.google.auto.value.AutoValue;

@AutoValue
public abstract class CommentStatement implements Statement {
  public abstract Comment comment();

  public static CommentStatement withComment(Comment comment) {
    return builder().setComment(comment).build();
  }

  @Override
  public void accept(AstNodeVisitor visitor) {
    visitor.visit(this);
  }

  private static Builder builder() {
    return new AutoValue_CommentStatement.Builder();
  }

  @AutoValue.Builder
  abstract static class Builder {
    public abstract Builder setComment(Comment comment);

    public abstract CommentStatement build();
  }
}
