package com.google.api.generator.gapic.model;

import com.google.api.FieldInfo;
import com.google.api.generator.engine.ast.TypeNode;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Field extends Field {

  private final String name;

  private final String originalName;

  private final TypeNode type;

  private final boolean isRequired;

  @Nullable
  private final FieldInfo.Format fieldInfoFormat;

  private final boolean isMessage;

  private final boolean isEnum;

  private final boolean isRepeated;

  private final boolean isMap;

  private final boolean isContainedInOneof;

  private final boolean isProto3Optional;

  @Nullable
  private final ResourceReference resourceReference;

  @Nullable
  private final String description;

  private AutoValue_Field(
      String name,
      String originalName,
      TypeNode type,
      boolean isRequired,
      @Nullable FieldInfo.Format fieldInfoFormat,
      boolean isMessage,
      boolean isEnum,
      boolean isRepeated,
      boolean isMap,
      boolean isContainedInOneof,
      boolean isProto3Optional,
      @Nullable ResourceReference resourceReference,
      @Nullable String description) {
    this.name = name;
    this.originalName = originalName;
    this.type = type;
    this.isRequired = isRequired;
    this.fieldInfoFormat = fieldInfoFormat;
    this.isMessage = isMessage;
    this.isEnum = isEnum;
    this.isRepeated = isRepeated;
    this.isMap = isMap;
    this.isContainedInOneof = isContainedInOneof;
    this.isProto3Optional = isProto3Optional;
    this.resourceReference = resourceReference;
    this.description = description;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String originalName() {
    return originalName;
  }

  @Override
  public TypeNode type() {
    return type;
  }

  @Override
  public boolean isRequired() {
    return isRequired;
  }

  @Nullable
  @Override
  public FieldInfo.Format fieldInfoFormat() {
    return fieldInfoFormat;
  }

  @Override
  public boolean isMessage() {
    return isMessage;
  }

  @Override
  public boolean isEnum() {
    return isEnum;
  }

  @Override
  public boolean isRepeated() {
    return isRepeated;
  }

  @Override
  public boolean isMap() {
    return isMap;
  }

  @Override
  public boolean isContainedInOneof() {
    return isContainedInOneof;
  }

  @Override
  public boolean isProto3Optional() {
    return isProto3Optional;
  }

  @Nullable
  @Override
  public ResourceReference resourceReference() {
    return resourceReference;
  }

  @Nullable
  @Override
  public String description() {
    return description;
  }

  @Override
  public String toString() {
    return "Field{"
        + "name=" + name + ", "
        + "originalName=" + originalName + ", "
        + "type=" + type + ", "
        + "isRequired=" + isRequired + ", "
        + "fieldInfoFormat=" + fieldInfoFormat + ", "
        + "isMessage=" + isMessage + ", "
        + "isEnum=" + isEnum + ", "
        + "isRepeated=" + isRepeated + ", "
        + "isMap=" + isMap + ", "
        + "isContainedInOneof=" + isContainedInOneof + ", "
        + "isProto3Optional=" + isProto3Optional + ", "
        + "resourceReference=" + resourceReference + ", "
        + "description=" + description
        + "}";
  }

  @Override
  public Field.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Field.Builder {
    private String name;
    private String originalName;
    private TypeNode type;
    private boolean isRequired;
    private FieldInfo.Format fieldInfoFormat;
    private boolean isMessage;
    private boolean isEnum;
    private boolean isRepeated;
    private boolean isMap;
    private boolean isContainedInOneof;
    private boolean isProto3Optional;
    private ResourceReference resourceReference;
    private String description;
    private byte set$0;
    Builder() {
    }
    private Builder(Field source) {
      this.name = source.name();
      this.originalName = source.originalName();
      this.type = source.type();
      this.isRequired = source.isRequired();
      this.fieldInfoFormat = source.fieldInfoFormat();
      this.isMessage = source.isMessage();
      this.isEnum = source.isEnum();
      this.isRepeated = source.isRepeated();
      this.isMap = source.isMap();
      this.isContainedInOneof = source.isContainedInOneof();
      this.isProto3Optional = source.isProto3Optional();
      this.resourceReference = source.resourceReference();
      this.description = source.description();
      set$0 = (byte) 0x7f;
    }
    @Override
    public Field.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    String name() {
      if (this.name == null) {
        throw new IllegalStateException("Property \"name\" has not been set");
      }
      return name;
    }
    @Override
    public Field.Builder setOriginalName(String originalName) {
      if (originalName == null) {
        throw new NullPointerException("Null originalName");
      }
      this.originalName = originalName;
      return this;
    }
    @Override
    Optional<String> originalName() {
      if (this.originalName == null) {
        return Optional.empty();
      }
      return Optional.of(originalName);
    }
    @Override
    public Field.Builder setType(TypeNode type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public Field.Builder setIsRequired(boolean isRequired) {
      this.isRequired = isRequired;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public Field.Builder setFieldInfoFormat(FieldInfo.Format fieldInfoFormat) {
      this.fieldInfoFormat = fieldInfoFormat;
      return this;
    }
    @Override
    public Field.Builder setIsMessage(boolean isMessage) {
      this.isMessage = isMessage;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public Field.Builder setIsEnum(boolean isEnum) {
      this.isEnum = isEnum;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public Field.Builder setIsRepeated(boolean isRepeated) {
      this.isRepeated = isRepeated;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public Field.Builder setIsMap(boolean isMap) {
      this.isMap = isMap;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    public Field.Builder setIsContainedInOneof(boolean isContainedInOneof) {
      this.isContainedInOneof = isContainedInOneof;
      set$0 |= (byte) 0x20;
      return this;
    }
    @Override
    public Field.Builder setIsProto3Optional(boolean isProto3Optional) {
      this.isProto3Optional = isProto3Optional;
      set$0 |= (byte) 0x40;
      return this;
    }
    @Override
    public Field.Builder setResourceReference(ResourceReference resourceReference) {
      this.resourceReference = resourceReference;
      return this;
    }
    @Override
    public Field.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    Field autoBuild() {
      if (set$0 != 0x7f
          || this.name == null
          || this.originalName == null
          || this.type == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.originalName == null) {
          missing.append(" originalName");
        }
        if (this.type == null) {
          missing.append(" type");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isRequired");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" isMessage");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" isEnum");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" isRepeated");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" isMap");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" isContainedInOneof");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" isProto3Optional");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Field(
          this.name,
          this.originalName,
          this.type,
          this.isRequired,
          this.fieldInfoFormat,
          this.isMessage,
          this.isEnum,
          this.isRepeated,
          this.isMap,
          this.isContainedInOneof,
          this.isProto3Optional,
          this.resourceReference,
          this.description);
    }
  }

}
