package com.google.api.generator.gapic.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GapicBatchingSettings extends GapicBatchingSettings {

  private final String protoPakkage;

  private final String serviceName;

  private final String methodName;

  private final int elementCountThreshold;

  private final long requestByteThreshold;

  private final long delayThresholdMillis;

  @Nullable
  private final Integer flowControlElementLimit;

  @Nullable
  private final Integer flowControlByteLimit;

  private final GapicBatchingSettings.FlowControlLimitExceededBehavior flowControlLimitExceededBehavior;

  private final String batchedFieldName;

  private final ImmutableList<String> discriminatorFieldNames;

  @Nullable
  private final String subresponseFieldName;

  private AutoValue_GapicBatchingSettings(
      String protoPakkage,
      String serviceName,
      String methodName,
      int elementCountThreshold,
      long requestByteThreshold,
      long delayThresholdMillis,
      @Nullable Integer flowControlElementLimit,
      @Nullable Integer flowControlByteLimit,
      GapicBatchingSettings.FlowControlLimitExceededBehavior flowControlLimitExceededBehavior,
      String batchedFieldName,
      ImmutableList<String> discriminatorFieldNames,
      @Nullable String subresponseFieldName) {
    this.protoPakkage = protoPakkage;
    this.serviceName = serviceName;
    this.methodName = methodName;
    this.elementCountThreshold = elementCountThreshold;
    this.requestByteThreshold = requestByteThreshold;
    this.delayThresholdMillis = delayThresholdMillis;
    this.flowControlElementLimit = flowControlElementLimit;
    this.flowControlByteLimit = flowControlByteLimit;
    this.flowControlLimitExceededBehavior = flowControlLimitExceededBehavior;
    this.batchedFieldName = batchedFieldName;
    this.discriminatorFieldNames = discriminatorFieldNames;
    this.subresponseFieldName = subresponseFieldName;
  }

  @Override
  public String protoPakkage() {
    return protoPakkage;
  }

  @Override
  public String serviceName() {
    return serviceName;
  }

  @Override
  public String methodName() {
    return methodName;
  }

  @Override
  public int elementCountThreshold() {
    return elementCountThreshold;
  }

  @Override
  public long requestByteThreshold() {
    return requestByteThreshold;
  }

  @Override
  public long delayThresholdMillis() {
    return delayThresholdMillis;
  }

  @Nullable
  @Override
  public Integer flowControlElementLimit() {
    return flowControlElementLimit;
  }

  @Nullable
  @Override
  public Integer flowControlByteLimit() {
    return flowControlByteLimit;
  }

  @Override
  public GapicBatchingSettings.FlowControlLimitExceededBehavior flowControlLimitExceededBehavior() {
    return flowControlLimitExceededBehavior;
  }

  @Override
  public String batchedFieldName() {
    return batchedFieldName;
  }

  @Override
  public ImmutableList<String> discriminatorFieldNames() {
    return discriminatorFieldNames;
  }

  @Nullable
  @Override
  public String subresponseFieldName() {
    return subresponseFieldName;
  }

  @Override
  public String toString() {
    return "GapicBatchingSettings{"
        + "protoPakkage=" + protoPakkage + ", "
        + "serviceName=" + serviceName + ", "
        + "methodName=" + methodName + ", "
        + "elementCountThreshold=" + elementCountThreshold + ", "
        + "requestByteThreshold=" + requestByteThreshold + ", "
        + "delayThresholdMillis=" + delayThresholdMillis + ", "
        + "flowControlElementLimit=" + flowControlElementLimit + ", "
        + "flowControlByteLimit=" + flowControlByteLimit + ", "
        + "flowControlLimitExceededBehavior=" + flowControlLimitExceededBehavior + ", "
        + "batchedFieldName=" + batchedFieldName + ", "
        + "discriminatorFieldNames=" + discriminatorFieldNames + ", "
        + "subresponseFieldName=" + subresponseFieldName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GapicBatchingSettings) {
      GapicBatchingSettings that = (GapicBatchingSettings) o;
      return this.protoPakkage.equals(that.protoPakkage())
          && this.serviceName.equals(that.serviceName())
          && this.methodName.equals(that.methodName())
          && this.elementCountThreshold == that.elementCountThreshold()
          && this.requestByteThreshold == that.requestByteThreshold()
          && this.delayThresholdMillis == that.delayThresholdMillis()
          && (this.flowControlElementLimit == null ? that.flowControlElementLimit() == null : this.flowControlElementLimit.equals(that.flowControlElementLimit()))
          && (this.flowControlByteLimit == null ? that.flowControlByteLimit() == null : this.flowControlByteLimit.equals(that.flowControlByteLimit()))
          && this.flowControlLimitExceededBehavior.equals(that.flowControlLimitExceededBehavior())
          && this.batchedFieldName.equals(that.batchedFieldName())
          && this.discriminatorFieldNames.equals(that.discriminatorFieldNames())
          && (this.subresponseFieldName == null ? that.subresponseFieldName() == null : this.subresponseFieldName.equals(that.subresponseFieldName()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= protoPakkage.hashCode();
    h$ *= 1000003;
    h$ ^= serviceName.hashCode();
    h$ *= 1000003;
    h$ ^= methodName.hashCode();
    h$ *= 1000003;
    h$ ^= elementCountThreshold;
    h$ *= 1000003;
    h$ ^= (int) ((requestByteThreshold >>> 32) ^ requestByteThreshold);
    h$ *= 1000003;
    h$ ^= (int) ((delayThresholdMillis >>> 32) ^ delayThresholdMillis);
    h$ *= 1000003;
    h$ ^= (flowControlElementLimit == null) ? 0 : flowControlElementLimit.hashCode();
    h$ *= 1000003;
    h$ ^= (flowControlByteLimit == null) ? 0 : flowControlByteLimit.hashCode();
    h$ *= 1000003;
    h$ ^= flowControlLimitExceededBehavior.hashCode();
    h$ *= 1000003;
    h$ ^= batchedFieldName.hashCode();
    h$ *= 1000003;
    h$ ^= discriminatorFieldNames.hashCode();
    h$ *= 1000003;
    h$ ^= (subresponseFieldName == null) ? 0 : subresponseFieldName.hashCode();
    return h$;
  }

  static final class Builder extends GapicBatchingSettings.Builder {
    private String protoPakkage;
    private String serviceName;
    private String methodName;
    private int elementCountThreshold;
    private long requestByteThreshold;
    private long delayThresholdMillis;
    private Integer flowControlElementLimit;
    private Integer flowControlByteLimit;
    private GapicBatchingSettings.FlowControlLimitExceededBehavior flowControlLimitExceededBehavior;
    private String batchedFieldName;
    private ImmutableList<String> discriminatorFieldNames;
    private String subresponseFieldName;
    private byte set$0;
    Builder() {
    }
    @Override
    public GapicBatchingSettings.Builder setProtoPakkage(String protoPakkage) {
      if (protoPakkage == null) {
        throw new NullPointerException("Null protoPakkage");
      }
      this.protoPakkage = protoPakkage;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setServiceName(String serviceName) {
      if (serviceName == null) {
        throw new NullPointerException("Null serviceName");
      }
      this.serviceName = serviceName;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setMethodName(String methodName) {
      if (methodName == null) {
        throw new NullPointerException("Null methodName");
      }
      this.methodName = methodName;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setElementCountThreshold(int elementCountThreshold) {
      this.elementCountThreshold = elementCountThreshold;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setRequestByteThreshold(long requestByteThreshold) {
      this.requestByteThreshold = requestByteThreshold;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setDelayThresholdMillis(long delayThresholdMillis) {
      this.delayThresholdMillis = delayThresholdMillis;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setFlowControlElementLimit(Integer flowControlElementLimit) {
      this.flowControlElementLimit = flowControlElementLimit;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setFlowControlByteLimit(Integer flowControlByteLimit) {
      this.flowControlByteLimit = flowControlByteLimit;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setFlowControlLimitExceededBehavior(GapicBatchingSettings.FlowControlLimitExceededBehavior flowControlLimitExceededBehavior) {
      if (flowControlLimitExceededBehavior == null) {
        throw new NullPointerException("Null flowControlLimitExceededBehavior");
      }
      this.flowControlLimitExceededBehavior = flowControlLimitExceededBehavior;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setBatchedFieldName(String batchedFieldName) {
      if (batchedFieldName == null) {
        throw new NullPointerException("Null batchedFieldName");
      }
      this.batchedFieldName = batchedFieldName;
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setDiscriminatorFieldNames(List<String> discriminatorFieldNames) {
      this.discriminatorFieldNames = ImmutableList.copyOf(discriminatorFieldNames);
      return this;
    }
    @Override
    public GapicBatchingSettings.Builder setSubresponseFieldName(String subresponseFieldName) {
      this.subresponseFieldName = subresponseFieldName;
      return this;
    }
    @Override
    public GapicBatchingSettings build() {
      if (set$0 != 7
          || this.protoPakkage == null
          || this.serviceName == null
          || this.methodName == null
          || this.flowControlLimitExceededBehavior == null
          || this.batchedFieldName == null
          || this.discriminatorFieldNames == null) {
        StringBuilder missing = new StringBuilder();
        if (this.protoPakkage == null) {
          missing.append(" protoPakkage");
        }
        if (this.serviceName == null) {
          missing.append(" serviceName");
        }
        if (this.methodName == null) {
          missing.append(" methodName");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" elementCountThreshold");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" requestByteThreshold");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" delayThresholdMillis");
        }
        if (this.flowControlLimitExceededBehavior == null) {
          missing.append(" flowControlLimitExceededBehavior");
        }
        if (this.batchedFieldName == null) {
          missing.append(" batchedFieldName");
        }
        if (this.discriminatorFieldNames == null) {
          missing.append(" discriminatorFieldNames");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GapicBatchingSettings(
          this.protoPakkage,
          this.serviceName,
          this.methodName,
          this.elementCountThreshold,
          this.requestByteThreshold,
          this.delayThresholdMillis,
          this.flowControlElementLimit,
          this.flowControlByteLimit,
          this.flowControlLimitExceededBehavior,
          this.batchedFieldName,
          this.discriminatorFieldNames,
          this.subresponseFieldName);
    }
  }

}
