package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.ClassDefinition;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GapicClass extends GapicClass {

  private final GapicClass.Kind kind;

  private final ClassDefinition classDefinition;

  private final List<Sample> samples;

  private final String apiShortName;

  private final String apiVersion;

  private AutoValue_GapicClass(
      GapicClass.Kind kind,
      ClassDefinition classDefinition,
      List<Sample> samples,
      String apiShortName,
      String apiVersion) {
    this.kind = kind;
    this.classDefinition = classDefinition;
    this.samples = samples;
    this.apiShortName = apiShortName;
    this.apiVersion = apiVersion;
  }

  @Override
  public GapicClass.Kind kind() {
    return kind;
  }

  @Override
  public ClassDefinition classDefinition() {
    return classDefinition;
  }

  @Override
  public List<Sample> samples() {
    return samples;
  }

  @Override
  public String apiShortName() {
    return apiShortName;
  }

  @Override
  public String apiVersion() {
    return apiVersion;
  }

  @Override
  public String toString() {
    return "GapicClass{"
        + "kind=" + kind + ", "
        + "classDefinition=" + classDefinition + ", "
        + "samples=" + samples + ", "
        + "apiShortName=" + apiShortName + ", "
        + "apiVersion=" + apiVersion
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GapicClass) {
      GapicClass that = (GapicClass) o;
      return this.kind.equals(that.kind())
          && this.classDefinition.equals(that.classDefinition())
          && this.samples.equals(that.samples())
          && this.apiShortName.equals(that.apiShortName())
          && this.apiVersion.equals(that.apiVersion());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= classDefinition.hashCode();
    h$ *= 1000003;
    h$ ^= samples.hashCode();
    h$ *= 1000003;
    h$ ^= apiShortName.hashCode();
    h$ *= 1000003;
    h$ ^= apiVersion.hashCode();
    return h$;
  }

  @Override
  GapicClass.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GapicClass.Builder {
    private GapicClass.Kind kind;
    private ClassDefinition classDefinition;
    private List<Sample> samples;
    private String apiShortName;
    private String apiVersion;
    Builder() {
    }
    private Builder(GapicClass source) {
      this.kind = source.kind();
      this.classDefinition = source.classDefinition();
      this.samples = source.samples();
      this.apiShortName = source.apiShortName();
      this.apiVersion = source.apiVersion();
    }
    @Override
    GapicClass.Builder setKind(GapicClass.Kind kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    GapicClass.Builder setClassDefinition(ClassDefinition classDefinition) {
      if (classDefinition == null) {
        throw new NullPointerException("Null classDefinition");
      }
      this.classDefinition = classDefinition;
      return this;
    }
    @Override
    GapicClass.Builder setSamples(List<Sample> samples) {
      if (samples == null) {
        throw new NullPointerException("Null samples");
      }
      this.samples = samples;
      return this;
    }
    @Override
    GapicClass.Builder setApiShortName(String apiShortName) {
      if (apiShortName == null) {
        throw new NullPointerException("Null apiShortName");
      }
      this.apiShortName = apiShortName;
      return this;
    }
    @Override
    GapicClass.Builder setApiVersion(String apiVersion) {
      if (apiVersion == null) {
        throw new NullPointerException("Null apiVersion");
      }
      this.apiVersion = apiVersion;
      return this;
    }
    @Override
    GapicClass build() {
      if (this.kind == null
          || this.classDefinition == null
          || this.samples == null
          || this.apiShortName == null
          || this.apiVersion == null) {
        StringBuilder missing = new StringBuilder();
        if (this.kind == null) {
          missing.append(" kind");
        }
        if (this.classDefinition == null) {
          missing.append(" classDefinition");
        }
        if (this.samples == null) {
          missing.append(" samples");
        }
        if (this.apiShortName == null) {
          missing.append(" apiShortName");
        }
        if (this.apiVersion == null) {
          missing.append(" apiVersion");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GapicClass(
          this.kind,
          this.classDefinition,
          this.samples,
          this.apiShortName,
          this.apiVersion);
    }
  }

}
