package com.google.api.generator.gapic.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GapicContext extends GapicContext {

  private final ImmutableMap<String, Message> messages;

  private final ImmutableMap<String, ResourceName> resourceNames;

  private final ImmutableList<com.google.api.generator.gapic.model.Service> services;

  private final ImmutableList<com.google.api.generator.gapic.model.Service> mixinServices;

  private final ImmutableMap<String, ResourceName> helperResourceNames;

  private final boolean gapicMetadataEnabled;

  private final boolean restNumericEnumsEnabled;

  @Nullable
  private final GapicServiceConfig serviceConfig;

  @Nullable
  private final com.google.api.Service serviceYamlProto;

  private final Transport transport;

  private AutoValue_GapicContext(
      ImmutableMap<String, Message> messages,
      ImmutableMap<String, ResourceName> resourceNames,
      ImmutableList<com.google.api.generator.gapic.model.Service> services,
      ImmutableList<com.google.api.generator.gapic.model.Service> mixinServices,
      ImmutableMap<String, ResourceName> helperResourceNames,
      boolean gapicMetadataEnabled,
      boolean restNumericEnumsEnabled,
      @Nullable GapicServiceConfig serviceConfig,
      @Nullable com.google.api.Service serviceYamlProto,
      Transport transport) {
    this.messages = messages;
    this.resourceNames = resourceNames;
    this.services = services;
    this.mixinServices = mixinServices;
    this.helperResourceNames = helperResourceNames;
    this.gapicMetadataEnabled = gapicMetadataEnabled;
    this.restNumericEnumsEnabled = restNumericEnumsEnabled;
    this.serviceConfig = serviceConfig;
    this.serviceYamlProto = serviceYamlProto;
    this.transport = transport;
  }

  @Override
  public ImmutableMap<String, Message> messages() {
    return messages;
  }

  @Override
  public ImmutableMap<String, ResourceName> resourceNames() {
    return resourceNames;
  }

  @Override
  public ImmutableList<com.google.api.generator.gapic.model.Service> services() {
    return services;
  }

  @Override
  public ImmutableList<com.google.api.generator.gapic.model.Service> mixinServices() {
    return mixinServices;
  }

  @Override
  public ImmutableMap<String, ResourceName> helperResourceNames() {
    return helperResourceNames;
  }

  @Override
  public boolean gapicMetadataEnabled() {
    return gapicMetadataEnabled;
  }

  @Override
  public boolean restNumericEnumsEnabled() {
    return restNumericEnumsEnabled;
  }

  @Nullable
  @Override
  public GapicServiceConfig serviceConfig() {
    return serviceConfig;
  }

  @Nullable
  @Override
  public com.google.api.Service serviceYamlProto() {
    return serviceYamlProto;
  }

  @Override
  public Transport transport() {
    return transport;
  }

  @Override
  public String toString() {
    return "GapicContext{"
        + "messages=" + messages + ", "
        + "resourceNames=" + resourceNames + ", "
        + "services=" + services + ", "
        + "mixinServices=" + mixinServices + ", "
        + "helperResourceNames=" + helperResourceNames + ", "
        + "gapicMetadataEnabled=" + gapicMetadataEnabled + ", "
        + "restNumericEnumsEnabled=" + restNumericEnumsEnabled + ", "
        + "serviceConfig=" + serviceConfig + ", "
        + "serviceYamlProto=" + serviceYamlProto + ", "
        + "transport=" + transport
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GapicContext) {
      GapicContext that = (GapicContext) o;
      return this.messages.equals(that.messages())
          && this.resourceNames.equals(that.resourceNames())
          && this.services.equals(that.services())
          && this.mixinServices.equals(that.mixinServices())
          && this.helperResourceNames.equals(that.helperResourceNames())
          && this.gapicMetadataEnabled == that.gapicMetadataEnabled()
          && this.restNumericEnumsEnabled == that.restNumericEnumsEnabled()
          && (this.serviceConfig == null ? that.serviceConfig() == null : this.serviceConfig.equals(that.serviceConfig()))
          && (this.serviceYamlProto == null ? that.serviceYamlProto() == null : this.serviceYamlProto.equals(that.serviceYamlProto()))
          && this.transport.equals(that.transport());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= messages.hashCode();
    h$ *= 1000003;
    h$ ^= resourceNames.hashCode();
    h$ *= 1000003;
    h$ ^= services.hashCode();
    h$ *= 1000003;
    h$ ^= mixinServices.hashCode();
    h$ *= 1000003;
    h$ ^= helperResourceNames.hashCode();
    h$ *= 1000003;
    h$ ^= gapicMetadataEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= restNumericEnumsEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (serviceConfig == null) ? 0 : serviceConfig.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceYamlProto == null) ? 0 : serviceYamlProto.hashCode();
    h$ *= 1000003;
    h$ ^= transport.hashCode();
    return h$;
  }

  @Override
  public GapicContext.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GapicContext.Builder {
    private ImmutableMap<String, Message> messages;
    private ImmutableMap<String, ResourceName> resourceNames;
    private ImmutableList<com.google.api.generator.gapic.model.Service> services;
    private ImmutableList<com.google.api.generator.gapic.model.Service> mixinServices;
    private ImmutableMap<String, ResourceName> helperResourceNames;
    private boolean gapicMetadataEnabled;
    private boolean restNumericEnumsEnabled;
    private GapicServiceConfig serviceConfig;
    private com.google.api.Service serviceYamlProto;
    private Transport transport;
    private byte set$0;
    Builder() {
    }
    private Builder(GapicContext source) {
      this.messages = source.messages();
      this.resourceNames = source.resourceNames();
      this.services = source.services();
      this.mixinServices = source.mixinServices();
      this.helperResourceNames = source.helperResourceNames();
      this.gapicMetadataEnabled = source.gapicMetadataEnabled();
      this.restNumericEnumsEnabled = source.restNumericEnumsEnabled();
      this.serviceConfig = source.serviceConfig();
      this.serviceYamlProto = source.serviceYamlProto();
      this.transport = source.transport();
      set$0 = (byte) 3;
    }
    @Override
    public GapicContext.Builder setMessages(Map<String, Message> messages) {
      this.messages = ImmutableMap.copyOf(messages);
      return this;
    }
    @Override
    public GapicContext.Builder setResourceNames(Map<String, ResourceName> resourceNames) {
      this.resourceNames = ImmutableMap.copyOf(resourceNames);
      return this;
    }
    @Override
    ImmutableMap<String, ResourceName> resourceNames() {
      if (this.resourceNames == null) {
        throw new IllegalStateException("Property \"resourceNames\" has not been set");
      }
      return resourceNames;
    }
    @Override
    public GapicContext.Builder setServices(List<com.google.api.generator.gapic.model.Service> services) {
      this.services = ImmutableList.copyOf(services);
      return this;
    }
    @Override
    public GapicContext.Builder setMixinServices(List<com.google.api.generator.gapic.model.Service> mixinServices) {
      this.mixinServices = ImmutableList.copyOf(mixinServices);
      return this;
    }
    @Override
    GapicContext.Builder setHelperResourceNames(Map<String, ResourceName> helperResourceNames) {
      this.helperResourceNames = ImmutableMap.copyOf(helperResourceNames);
      return this;
    }
    @Override
    ImmutableMap<String, ResourceName> helperResourceNames() {
      if (this.helperResourceNames == null) {
        throw new IllegalStateException("Property \"helperResourceNames\" has not been set");
      }
      return helperResourceNames;
    }
    @Override
    public GapicContext.Builder setGapicMetadataEnabled(boolean gapicMetadataEnabled) {
      this.gapicMetadataEnabled = gapicMetadataEnabled;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public GapicContext.Builder setRestNumericEnumsEnabled(boolean restNumericEnumsEnabled) {
      this.restNumericEnumsEnabled = restNumericEnumsEnabled;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public GapicContext.Builder setServiceConfig(GapicServiceConfig serviceConfig) {
      this.serviceConfig = serviceConfig;
      return this;
    }
    @Override
    public GapicContext.Builder setServiceYamlProto(com.google.api.Service serviceYamlProto) {
      this.serviceYamlProto = serviceYamlProto;
      return this;
    }
    @Override
    public GapicContext.Builder setTransport(Transport transport) {
      if (transport == null) {
        throw new NullPointerException("Null transport");
      }
      this.transport = transport;
      return this;
    }
    @Override
    GapicContext autoBuild() {
      if (set$0 != 3
          || this.messages == null
          || this.resourceNames == null
          || this.services == null
          || this.mixinServices == null
          || this.helperResourceNames == null
          || this.transport == null) {
        StringBuilder missing = new StringBuilder();
        if (this.messages == null) {
          missing.append(" messages");
        }
        if (this.resourceNames == null) {
          missing.append(" resourceNames");
        }
        if (this.services == null) {
          missing.append(" services");
        }
        if (this.mixinServices == null) {
          missing.append(" mixinServices");
        }
        if (this.helperResourceNames == null) {
          missing.append(" helperResourceNames");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" gapicMetadataEnabled");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" restNumericEnumsEnabled");
        }
        if (this.transport == null) {
          missing.append(" transport");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GapicContext(
          this.messages,
          this.resourceNames,
          this.services,
          this.mixinServices,
          this.helperResourceNames,
          this.gapicMetadataEnabled,
          this.restNumericEnumsEnabled,
          this.serviceConfig,
          this.serviceYamlProto,
          this.transport);
    }
  }

}
