package com.google.api.generator.gapic.model;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GapicLroRetrySettings extends GapicLroRetrySettings {

  private final String protoPakkage;

  private final String serviceName;

  private final String methodName;

  private final long initialPollDelayMillis;

  private final double pollDelayMultiplier;

  private final long maxPollDelayMillis;

  private final long totalPollTimeoutMillis;

  private AutoValue_GapicLroRetrySettings(
      String protoPakkage,
      String serviceName,
      String methodName,
      long initialPollDelayMillis,
      double pollDelayMultiplier,
      long maxPollDelayMillis,
      long totalPollTimeoutMillis) {
    this.protoPakkage = protoPakkage;
    this.serviceName = serviceName;
    this.methodName = methodName;
    this.initialPollDelayMillis = initialPollDelayMillis;
    this.pollDelayMultiplier = pollDelayMultiplier;
    this.maxPollDelayMillis = maxPollDelayMillis;
    this.totalPollTimeoutMillis = totalPollTimeoutMillis;
  }

  @Override
  public String protoPakkage() {
    return protoPakkage;
  }

  @Override
  public String serviceName() {
    return serviceName;
  }

  @Override
  public String methodName() {
    return methodName;
  }

  @Override
  public long initialPollDelayMillis() {
    return initialPollDelayMillis;
  }

  @Override
  public double pollDelayMultiplier() {
    return pollDelayMultiplier;
  }

  @Override
  public long maxPollDelayMillis() {
    return maxPollDelayMillis;
  }

  @Override
  public long totalPollTimeoutMillis() {
    return totalPollTimeoutMillis;
  }

  @Override
  public String toString() {
    return "GapicLroRetrySettings{"
        + "protoPakkage=" + protoPakkage + ", "
        + "serviceName=" + serviceName + ", "
        + "methodName=" + methodName + ", "
        + "initialPollDelayMillis=" + initialPollDelayMillis + ", "
        + "pollDelayMultiplier=" + pollDelayMultiplier + ", "
        + "maxPollDelayMillis=" + maxPollDelayMillis + ", "
        + "totalPollTimeoutMillis=" + totalPollTimeoutMillis
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GapicLroRetrySettings) {
      GapicLroRetrySettings that = (GapicLroRetrySettings) o;
      return this.protoPakkage.equals(that.protoPakkage())
          && this.serviceName.equals(that.serviceName())
          && this.methodName.equals(that.methodName())
          && this.initialPollDelayMillis == that.initialPollDelayMillis()
          && Double.doubleToLongBits(this.pollDelayMultiplier) == Double.doubleToLongBits(that.pollDelayMultiplier())
          && this.maxPollDelayMillis == that.maxPollDelayMillis()
          && this.totalPollTimeoutMillis == that.totalPollTimeoutMillis();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= protoPakkage.hashCode();
    h$ *= 1000003;
    h$ ^= serviceName.hashCode();
    h$ *= 1000003;
    h$ ^= methodName.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((initialPollDelayMillis >>> 32) ^ initialPollDelayMillis);
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(pollDelayMultiplier) >>> 32) ^ Double.doubleToLongBits(pollDelayMultiplier));
    h$ *= 1000003;
    h$ ^= (int) ((maxPollDelayMillis >>> 32) ^ maxPollDelayMillis);
    h$ *= 1000003;
    h$ ^= (int) ((totalPollTimeoutMillis >>> 32) ^ totalPollTimeoutMillis);
    return h$;
  }

  static final class Builder extends GapicLroRetrySettings.Builder {
    private String protoPakkage;
    private String serviceName;
    private String methodName;
    private long initialPollDelayMillis;
    private double pollDelayMultiplier;
    private long maxPollDelayMillis;
    private long totalPollTimeoutMillis;
    private byte set$0;
    Builder() {
    }
    @Override
    public GapicLroRetrySettings.Builder setProtoPakkage(String protoPakkage) {
      if (protoPakkage == null) {
        throw new NullPointerException("Null protoPakkage");
      }
      this.protoPakkage = protoPakkage;
      return this;
    }
    @Override
    public GapicLroRetrySettings.Builder setServiceName(String serviceName) {
      if (serviceName == null) {
        throw new NullPointerException("Null serviceName");
      }
      this.serviceName = serviceName;
      return this;
    }
    @Override
    public GapicLroRetrySettings.Builder setMethodName(String methodName) {
      if (methodName == null) {
        throw new NullPointerException("Null methodName");
      }
      this.methodName = methodName;
      return this;
    }
    @Override
    public GapicLroRetrySettings.Builder setInitialPollDelayMillis(long initialPollDelayMillis) {
      this.initialPollDelayMillis = initialPollDelayMillis;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public GapicLroRetrySettings.Builder setPollDelayMultiplier(double pollDelayMultiplier) {
      this.pollDelayMultiplier = pollDelayMultiplier;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public GapicLroRetrySettings.Builder setMaxPollDelayMillis(long maxPollDelayMillis) {
      this.maxPollDelayMillis = maxPollDelayMillis;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public GapicLroRetrySettings.Builder setTotalPollTimeoutMillis(long totalPollTimeoutMillis) {
      this.totalPollTimeoutMillis = totalPollTimeoutMillis;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public GapicLroRetrySettings build() {
      if (set$0 != 0xf
          || this.protoPakkage == null
          || this.serviceName == null
          || this.methodName == null) {
        StringBuilder missing = new StringBuilder();
        if (this.protoPakkage == null) {
          missing.append(" protoPakkage");
        }
        if (this.serviceName == null) {
          missing.append(" serviceName");
        }
        if (this.methodName == null) {
          missing.append(" methodName");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" initialPollDelayMillis");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" pollDelayMultiplier");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" maxPollDelayMillis");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" totalPollTimeoutMillis");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GapicLroRetrySettings(
          this.protoPakkage,
          this.serviceName,
          this.methodName,
          this.initialPollDelayMillis,
          this.pollDelayMultiplier,
          this.maxPollDelayMillis,
          this.totalPollTimeoutMillis);
    }
  }

}
