package com.google.api.generator.gapic.model;

import com.google.protobuf.Duration;
import io.grpc.serviceconfig.MethodConfig;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GapicRetrySettings extends GapicRetrySettings {

  private final Duration timeout;

  private final MethodConfig.RetryPolicy retryPolicy;

  private final GapicRetrySettings.Kind kind;

  private AutoValue_GapicRetrySettings(
      Duration timeout,
      MethodConfig.RetryPolicy retryPolicy,
      GapicRetrySettings.Kind kind) {
    this.timeout = timeout;
    this.retryPolicy = retryPolicy;
    this.kind = kind;
  }

  @Override
  public Duration timeout() {
    return timeout;
  }

  @Override
  public MethodConfig.RetryPolicy retryPolicy() {
    return retryPolicy;
  }

  @Override
  public GapicRetrySettings.Kind kind() {
    return kind;
  }

  @Override
  public String toString() {
    return "GapicRetrySettings{"
        + "timeout=" + timeout + ", "
        + "retryPolicy=" + retryPolicy + ", "
        + "kind=" + kind
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GapicRetrySettings) {
      GapicRetrySettings that = (GapicRetrySettings) o;
      return this.timeout.equals(that.timeout())
          && this.retryPolicy.equals(that.retryPolicy())
          && this.kind.equals(that.kind());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= timeout.hashCode();
    h$ *= 1000003;
    h$ ^= retryPolicy.hashCode();
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    return h$;
  }

  static final class Builder extends GapicRetrySettings.Builder {
    private Duration timeout;
    private MethodConfig.RetryPolicy retryPolicy;
    private GapicRetrySettings.Kind kind;
    Builder() {
    }
    @Override
    public GapicRetrySettings.Builder setTimeout(Duration timeout) {
      if (timeout == null) {
        throw new NullPointerException("Null timeout");
      }
      this.timeout = timeout;
      return this;
    }
    @Override
    public GapicRetrySettings.Builder setRetryPolicy(MethodConfig.RetryPolicy retryPolicy) {
      if (retryPolicy == null) {
        throw new NullPointerException("Null retryPolicy");
      }
      this.retryPolicy = retryPolicy;
      return this;
    }
    @Override
    public GapicRetrySettings.Builder setKind(GapicRetrySettings.Kind kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public GapicRetrySettings build() {
      if (this.timeout == null
          || this.retryPolicy == null
          || this.kind == null) {
        StringBuilder missing = new StringBuilder();
        if (this.timeout == null) {
          missing.append(" timeout");
        }
        if (this.retryPolicy == null) {
          missing.append(" retryPolicy");
        }
        if (this.kind == null) {
          missing.append(" kind");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GapicRetrySettings(
          this.timeout,
          this.retryPolicy,
          this.kind);
    }
  }

}
