package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.TypeNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Method extends Method {

  private final String name;

  private final Method.Stream stream;

  private final TypeNode inputType;

  private final TypeNode outputType;

  private final boolean isBatching;

  @Nullable
  private final String pageSizeFieldName;

  private final boolean isDeprecated;

  @Nullable
  private final LongrunningOperation lro;

  @Nullable
  private final String description;

  @Nullable
  private final String mixedInApiName;

  @Nullable
  private final HttpBindings httpBindings;

  @Nullable
  private final RoutingHeaderRule routingHeaderRule;

  private final ImmutableList<List<MethodArgument>> methodSignatures;

  private final List<String> autoPopulatedFields;

  private final boolean operationPollingMethod;

  private AutoValue_Method(
      String name,
      Method.Stream stream,
      TypeNode inputType,
      TypeNode outputType,
      boolean isBatching,
      @Nullable String pageSizeFieldName,
      boolean isDeprecated,
      @Nullable LongrunningOperation lro,
      @Nullable String description,
      @Nullable String mixedInApiName,
      @Nullable HttpBindings httpBindings,
      @Nullable RoutingHeaderRule routingHeaderRule,
      ImmutableList<List<MethodArgument>> methodSignatures,
      List<String> autoPopulatedFields,
      boolean operationPollingMethod) {
    this.name = name;
    this.stream = stream;
    this.inputType = inputType;
    this.outputType = outputType;
    this.isBatching = isBatching;
    this.pageSizeFieldName = pageSizeFieldName;
    this.isDeprecated = isDeprecated;
    this.lro = lro;
    this.description = description;
    this.mixedInApiName = mixedInApiName;
    this.httpBindings = httpBindings;
    this.routingHeaderRule = routingHeaderRule;
    this.methodSignatures = methodSignatures;
    this.autoPopulatedFields = autoPopulatedFields;
    this.operationPollingMethod = operationPollingMethod;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public Method.Stream stream() {
    return stream;
  }

  @Override
  public TypeNode inputType() {
    return inputType;
  }

  @Override
  public TypeNode outputType() {
    return outputType;
  }

  @Override
  public boolean isBatching() {
    return isBatching;
  }

  @Nullable
  @Override
  public String pageSizeFieldName() {
    return pageSizeFieldName;
  }

  @Override
  public boolean isDeprecated() {
    return isDeprecated;
  }

  @Nullable
  @Override
  public LongrunningOperation lro() {
    return lro;
  }

  @Nullable
  @Override
  public String description() {
    return description;
  }

  @Nullable
  @Override
  public String mixedInApiName() {
    return mixedInApiName;
  }

  @Nullable
  @Override
  public HttpBindings httpBindings() {
    return httpBindings;
  }

  @Nullable
  @Override
  public RoutingHeaderRule routingHeaderRule() {
    return routingHeaderRule;
  }

  @Override
  public ImmutableList<List<MethodArgument>> methodSignatures() {
    return methodSignatures;
  }

  @Override
  public List<String> autoPopulatedFields() {
    return autoPopulatedFields;
  }

  @Override
  public boolean operationPollingMethod() {
    return operationPollingMethod;
  }

  @Override
  public String toString() {
    return "Method{"
        + "name=" + name + ", "
        + "stream=" + stream + ", "
        + "inputType=" + inputType + ", "
        + "outputType=" + outputType + ", "
        + "isBatching=" + isBatching + ", "
        + "pageSizeFieldName=" + pageSizeFieldName + ", "
        + "isDeprecated=" + isDeprecated + ", "
        + "lro=" + lro + ", "
        + "description=" + description + ", "
        + "mixedInApiName=" + mixedInApiName + ", "
        + "httpBindings=" + httpBindings + ", "
        + "routingHeaderRule=" + routingHeaderRule + ", "
        + "methodSignatures=" + methodSignatures + ", "
        + "autoPopulatedFields=" + autoPopulatedFields + ", "
        + "operationPollingMethod=" + operationPollingMethod
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Method) {
      Method that = (Method) o;
      return this.name.equals(that.name())
          && this.stream.equals(that.stream())
          && this.inputType.equals(that.inputType())
          && this.outputType.equals(that.outputType())
          && this.isBatching == that.isBatching()
          && (this.pageSizeFieldName == null ? that.pageSizeFieldName() == null : this.pageSizeFieldName.equals(that.pageSizeFieldName()))
          && this.isDeprecated == that.isDeprecated()
          && (this.lro == null ? that.lro() == null : this.lro.equals(that.lro()))
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && (this.mixedInApiName == null ? that.mixedInApiName() == null : this.mixedInApiName.equals(that.mixedInApiName()))
          && (this.httpBindings == null ? that.httpBindings() == null : this.httpBindings.equals(that.httpBindings()))
          && (this.routingHeaderRule == null ? that.routingHeaderRule() == null : this.routingHeaderRule.equals(that.routingHeaderRule()))
          && this.methodSignatures.equals(that.methodSignatures())
          && this.autoPopulatedFields.equals(that.autoPopulatedFields())
          && this.operationPollingMethod == that.operationPollingMethod();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= stream.hashCode();
    h$ *= 1000003;
    h$ ^= inputType.hashCode();
    h$ *= 1000003;
    h$ ^= outputType.hashCode();
    h$ *= 1000003;
    h$ ^= isBatching ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (pageSizeFieldName == null) ? 0 : pageSizeFieldName.hashCode();
    h$ *= 1000003;
    h$ ^= isDeprecated ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (lro == null) ? 0 : lro.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= (mixedInApiName == null) ? 0 : mixedInApiName.hashCode();
    h$ *= 1000003;
    h$ ^= (httpBindings == null) ? 0 : httpBindings.hashCode();
    h$ *= 1000003;
    h$ ^= (routingHeaderRule == null) ? 0 : routingHeaderRule.hashCode();
    h$ *= 1000003;
    h$ ^= methodSignatures.hashCode();
    h$ *= 1000003;
    h$ ^= autoPopulatedFields.hashCode();
    h$ *= 1000003;
    h$ ^= operationPollingMethod ? 1231 : 1237;
    return h$;
  }

  @Override
  public Method.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Method.Builder {
    private String name;
    private Method.Stream stream;
    private TypeNode inputType;
    private TypeNode outputType;
    private boolean isBatching;
    private String pageSizeFieldName;
    private boolean isDeprecated;
    private LongrunningOperation lro;
    private String description;
    private String mixedInApiName;
    private HttpBindings httpBindings;
    private RoutingHeaderRule routingHeaderRule;
    private ImmutableList<List<MethodArgument>> methodSignatures;
    private List<String> autoPopulatedFields;
    private boolean operationPollingMethod;
    private byte set$0;
    Builder() {
    }
    private Builder(Method source) {
      this.name = source.name();
      this.stream = source.stream();
      this.inputType = source.inputType();
      this.outputType = source.outputType();
      this.isBatching = source.isBatching();
      this.pageSizeFieldName = source.pageSizeFieldName();
      this.isDeprecated = source.isDeprecated();
      this.lro = source.lro();
      this.description = source.description();
      this.mixedInApiName = source.mixedInApiName();
      this.httpBindings = source.httpBindings();
      this.routingHeaderRule = source.routingHeaderRule();
      this.methodSignatures = source.methodSignatures();
      this.autoPopulatedFields = source.autoPopulatedFields();
      this.operationPollingMethod = source.operationPollingMethod();
      set$0 = (byte) 7;
    }
    @Override
    public Method.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public Method.Builder setStream(Method.Stream stream) {
      if (stream == null) {
        throw new NullPointerException("Null stream");
      }
      this.stream = stream;
      return this;
    }
    @Override
    public Method.Builder setInputType(TypeNode inputType) {
      if (inputType == null) {
        throw new NullPointerException("Null inputType");
      }
      this.inputType = inputType;
      return this;
    }
    @Override
    public Method.Builder setOutputType(TypeNode outputType) {
      if (outputType == null) {
        throw new NullPointerException("Null outputType");
      }
      this.outputType = outputType;
      return this;
    }
    @Override
    public Method.Builder setIsBatching(boolean isBatching) {
      this.isBatching = isBatching;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public Method.Builder setPageSizeFieldName(String pageSizeFieldName) {
      this.pageSizeFieldName = pageSizeFieldName;
      return this;
    }
    @Override
    public Method.Builder setIsDeprecated(boolean isDeprecated) {
      this.isDeprecated = isDeprecated;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public Method.Builder setLro(LongrunningOperation lro) {
      this.lro = lro;
      return this;
    }
    @Override
    public Method.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    public Method.Builder setMixedInApiName(String mixedInApiName) {
      this.mixedInApiName = mixedInApiName;
      return this;
    }
    @Override
    public Method.Builder setHttpBindings(HttpBindings httpBindings) {
      this.httpBindings = httpBindings;
      return this;
    }
    @Override
    public Method.Builder setRoutingHeaderRule(RoutingHeaderRule routingHeaderRule) {
      this.routingHeaderRule = routingHeaderRule;
      return this;
    }
    @Override
    public Method.Builder setMethodSignatures(List<List<MethodArgument>> methodSignatures) {
      this.methodSignatures = ImmutableList.copyOf(methodSignatures);
      return this;
    }
    @Override
    public Method.Builder setAutoPopulatedFields(List<String> autoPopulatedFields) {
      if (autoPopulatedFields == null) {
        throw new NullPointerException("Null autoPopulatedFields");
      }
      this.autoPopulatedFields = autoPopulatedFields;
      return this;
    }
    @Override
    public Method.Builder setOperationPollingMethod(boolean operationPollingMethod) {
      this.operationPollingMethod = operationPollingMethod;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public Method build() {
      if (set$0 != 7
          || this.name == null
          || this.stream == null
          || this.inputType == null
          || this.outputType == null
          || this.methodSignatures == null
          || this.autoPopulatedFields == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.stream == null) {
          missing.append(" stream");
        }
        if (this.inputType == null) {
          missing.append(" inputType");
        }
        if (this.outputType == null) {
          missing.append(" outputType");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isBatching");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" isDeprecated");
        }
        if (this.methodSignatures == null) {
          missing.append(" methodSignatures");
        }
        if (this.autoPopulatedFields == null) {
          missing.append(" autoPopulatedFields");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" operationPollingMethod");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Method(
          this.name,
          this.stream,
          this.inputType,
          this.outputType,
          this.isBatching,
          this.pageSizeFieldName,
          this.isDeprecated,
          this.lro,
          this.description,
          this.mixedInApiName,
          this.httpBindings,
          this.routingHeaderRule,
          this.methodSignatures,
          this.autoPopulatedFields,
          this.operationPollingMethod);
    }
  }

}
