package com.google.api.generator.gapic.model;

import com.google.protobuf.Duration;
import io.grpc.serviceconfig.MethodConfig;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RetrySettings extends RetrySettings {

  private final Duration timeout;

  private final MethodConfig.RetryPolicy retryPolicy;

  private AutoValue_RetrySettings(
      Duration timeout,
      MethodConfig.RetryPolicy retryPolicy) {
    this.timeout = timeout;
    this.retryPolicy = retryPolicy;
  }

  @Override
  public Duration timeout() {
    return timeout;
  }

  @Override
  public MethodConfig.RetryPolicy retryPolicy() {
    return retryPolicy;
  }

  @Override
  public String toString() {
    return "RetrySettings{"
        + "timeout=" + timeout + ", "
        + "retryPolicy=" + retryPolicy
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RetrySettings) {
      RetrySettings that = (RetrySettings) o;
      return this.timeout.equals(that.timeout())
          && this.retryPolicy.equals(that.retryPolicy());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= timeout.hashCode();
    h$ *= 1000003;
    h$ ^= retryPolicy.hashCode();
    return h$;
  }

  static final class Builder extends RetrySettings.Builder {
    private Duration timeout;
    private MethodConfig.RetryPolicy retryPolicy;
    Builder() {
    }
    @Override
    RetrySettings.Builder setTimeout(Duration timeout) {
      if (timeout == null) {
        throw new NullPointerException("Null timeout");
      }
      this.timeout = timeout;
      return this;
    }
    @Override
    RetrySettings.Builder setRetryPolicy(MethodConfig.RetryPolicy retryPolicy) {
      if (retryPolicy == null) {
        throw new NullPointerException("Null retryPolicy");
      }
      this.retryPolicy = retryPolicy;
      return this;
    }
    @Override
    RetrySettings build() {
      if (this.timeout == null
          || this.retryPolicy == null) {
        StringBuilder missing = new StringBuilder();
        if (this.timeout == null) {
          missing.append(" timeout");
        }
        if (this.retryPolicy == null) {
          missing.append(" retryPolicy");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RetrySettings(
          this.timeout,
          this.retryPolicy);
    }
  }

}
